% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PN-epiSIS-network-T.R
\name{spn_T_epiSIS_network}
\alias{spn_T_epiSIS_network}
\title{Make Transitions (T) For a Network (SEI Mosquitoes - SIS Humans)}
\usage{
spn_T_epiSIS_network(node_list, spn_P, params, cube, h_move, m_move)
}
\arguments{
\item{node_list}{a character vector specifying what type of nodes to create;
(m = a node with only mosquitoes, h = a node with only humans, b = a node with both humans and mosquitoes)}

\item{spn_P}{set of places produced by \code{\link{spn_P_epiSIS_network}}}

\item{params}{a named list of parameters (see details)}

\item{cube}{an inheritance cube from the \code{MGDrivE} package (e.g. \code{\link[MGDrivE]{cubeMendelian}})}

\item{h_move}{binary adjacency matrix indicating if movement of humans between nodes is possible or not}

\item{m_move}{binary adjacency matrix indicating if movement of mosquitoes between nodes is possible or not}
}
\value{
a list with two elements: \code{T} contains transitions packets as lists,
\code{v} is the character vector of transitions (T)
}
\description{
This function makes the set of transitions (T) for a SPN model of a
metapopulation network for simulation of coupled SEI-SIS dynamics. It is the
network version of \code{\link{spn_T_epiSIS_node}}.
}
\details{
This function takes the places produced from \code{\link{spn_P_epiSIS_network}}
and builds all possible transitions between subsets of those places.

The \code{params} argument supplies all of the ecological parameters necessary
to calculate equilibrium values. This function requires the \code{nE},
\code{nL}, \code{nP}, and \code{nEIP} parameters to be specified. For more details, see
\code{\link{equilibrium_SEI_SIS}}

While this function produces all structural information related to transitions,
hazards are produced by a separate function, \code{\link{spn_hazards}}.

For larger networks, this function may take some time to return, please be patient;
the Petri Net modeling formalism trades additional computation time at model
initialization for faster sampling of trajectories within a simulation.

Please note, the movement matrices (\code{h_move} and \code{m_move}) are NOT
stochastic matrices, just binary matrices that say if i,j can exchange population.
Diagonal elements must be \code{FALSE}, and both matrices are checked for validity; the
function will stop with errors if the adjacency matrix specifies illegal movement
rules (e.g.; mosquito movement from a "h" node to a "b" node)

For examples of using this function, see:
\code{vignette("epi-network", package = "MGDrivE2")}
}
