% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kfilter.R
\name{Kfilter}
\alias{Kfilter}
\title{The Kolmogorov filter for variable screening}
\usage{
Kfilter(X, Y, nsis = (dim(X)[1])/log(dim(X)[1]))
}
\arguments{
\item{X}{The design matrix of dimensions n * p. Each row is an observation vector.}

\item{Y}{The response vector of dimension n * 1.}

\item{nsis}{Number of predictors recruited by SIS. The default is n/log(n).}
}
\value{
the labels of first nsis largest active set of all predictors
}
\description{
A new model-free screening method called the fused Kolmogorov filter is proposed for high-dimensional data analysis.
This new method is fully nonparametric and can work with many types of covariates and response variables, including continuous,
discrete and categorical variables.
}
\examples{

n=100;
p=200;
rho=0.5;
data=GendataLM(n,p,rho,error="gaussian")
data=cbind(data[[1]],data[[2]])
colnames(data)[1:ncol(data)]=c(paste0("X",1:(ncol(data)-1)),"Y")
data=as.matrix(data)
X=data[,1:(ncol(data)-1)];
Y=data[,ncol(data)];
A=Kfilter(X,Y,n/log(n));A

}
\references{
Mai, Q., & Zou, H. (2013). The Kolmogorov filter for variable screening in high-dimensional binary classification. Biometrika, 100(1), 229-234.

Mai, Q., & Zou, H. (2015). The fused Kolmogorov filter: A nonparametric model-free screening method. The Annals of Statistics, 43(4), 1471-1497.
}
\author{
Xuewei Cheng \email{xwcheng@csu.edu.cn}
}
