% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc.R
\name{auc}
\alias{auc}
\title{Compute the area under the curve for two vectors.}
\usage{
auc(x, y, from = min(x, na.rm = TRUE), to = max(x, na.rm = TRUE),
  type = c("linear", "spline"), absolutearea = FALSE, ...)
}
\arguments{
\item{x}{a numeric vector of x values.}

\item{y}{a numeric vector of y values of the same length as x.}

\item{from}{The value from where to start calculating the area under the
curve. Defaults to the smallest x value.}

\item{to}{The value from where to end the calculation of the area under the
curve. Defaults to the greatest x value.}

\item{type}{The type of interpolation. Defaults to "linear" for area under
the curve for linear interpolation. The value "spline" results in the area
under the natural cubic spline interpolation.}

\item{absolutearea}{A logical value that determines if negative
areas should be added to the total area under the curve.  By
default the auc function subtracts areas that have negative y
values. Set \code{absolutearea=TRUE} to _add_ the absolute value of the negative areas to the total area.}

\item{\dots}{additional arguments passed on to approx. In particular rule
can be set to determine how values outside the range of x is handled.}
}
\value{
The value of the area under the curve.
}
\description{
Compute the area under the curve using linear or natural spline
interpolation for two vectors where one corresponds to the x values and the
other corresponds to the y values.
}
\details{
For linear interpolation the auc function computes the area under the curve
using the composite trapezoid rule.  For area under a spline interpolation,
auc uses the splinefun function in combination with the integrate to
calculate a numerical integral. The auc function can handle unsorted time
values, missing observations, ties for the time values, and integrating over
part of the area or even outside the area.
}
\examples{

x <- 1:4
y <- c(0, 1, 1, 5)
auc(x, y)

# AUC from 0 to max(x) where we allow for extrapolation
auc(x, y, from=0, rule=2)

# Use value 0 to the left
auc(x, y, from=0, rule=2, yleft=0)

# Use 1/2 to the left
auc(x, y, from=0, rule=2, yleft=.5)

# Use 1/2 to the left with spline interpolation
auc(x, y, from=0, rule=2, yleft=.5)


}
\seealso{
\code{\link{approx}}, \code{\link{splinefun}},
\code{\link{integrate}}
}
\author{
Claus Ekstrom \email{claus@rprimer.dk}
}
\keyword{datagen}
