% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{MEDseq_meantime}
\alias{MEDseq_meantime}
\title{Compute the mean time spent in each sequence category}
\usage{
MEDseq_meantime(x,
                MAP = FALSE,
                norm = TRUE)
}
\arguments{
\item{x}{An object of class \code{"MEDseq"} generated by \code{\link{MEDseq_fit}} or an object of class \code{"MEDseqCompare"} generated by \code{\link{MEDseq_compare}}.}

\item{MAP}{A logical indicating whether to use the MAP classification in the computation of the averages, or the 'soft' clustering assignments given by \code{x$z}. Defaults to \code{FALSE}, but is always \code{TRUE} for models fitted by the CEM algorithm (see \code{\link{MEDseq_control}}).}

\item{norm}{A logical indicating whether the mean times are normalised to sum to the sequence length within each cluster (defaults to \code{TRUE}). Otherwise, when \code{FALSE}, entries give the total (weighted) number of times a given sequence category was observered in a given cluster.}
}
\value{
A matrix with sequence category and cluster-specific mean times, giving clusters on the rows, corresponding cluster sizes in the first column, and sequence categories in the remaining columns.
}
\description{
Computes the mean time (per cluster) spent in each sequence category (i.e. state value) for a fitted \code{MEDseq} model.
}
\details{
Models with weights, covariates, &/or a noise component are also accounted for.
}
\examples{
\donttest{data(biofam)

mod <- MEDseq_fit(seqdef(biofam[10:25] + 1L), G=10, modtype="UUN")

MEDseq_meantime(mod)
MEDseq_meantime(mod, MAP=TRUE, norm=FALSE)}
}
\references{
Keefe Murphy, T. Brendan Murphy, Raffaella Piccarreta, and I. Claire Gormley (2019). Clustering longitudinal life-course sequences using mixtures of exponential-distance models. \emph{To appear}. <\href{https://arxiv.org/abs/1908.07963}{arXiv:1908.07963}>.
}
\seealso{
\code{\link{MEDseq_fit}}, \code{\link{MEDseq_control}}
}
\author{
Keefe Murphy - <\email{keefe.murphy@ucd.ie}>
}
\keyword{utility}
