% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{calc.nswaps}
\alias{calc.nswaps}
\title{Calculates the number of swaps required to move from one order to another.}
\usage{
calc.nswaps(map1, map2)
}
\arguments{
\item{map1}{Vector of marker positions or ranks.}

\item{map2}{Vector of marker positions or ranks.}
}
\value{
Scalar giving the number of swaps.
}
\description{
Calculates the number of swaps required to move from one order to another.
}
\details{
This is intended to be used when comparing an estimated marker ordering to 
some perceived "truth". It is most likely to be useful when dealing with 
simulated data where the concept of truth makes most sense. It calculates 
the minimum number of single place swaps that would be needed to move from 
\code{map1} to \code{map2} and it does this by reverse engineering kendall's tau b 
correlation coefficient 
\deqn{\tau=\frac{2(C-D)}{N}}{\tau=2(C-D)/N}
where \eqn{N} is the total number of pairs of markers, \eqn{C} the number of concordant pairs and \eqn{D} the number 
of discordant pairs. If there are \eqn{n} markers then the total number of pairs 
\eqn{N={{n}\choose{2}}}{N=nC_2} and \eqn{C=N-D} so \eqn{D=0.5 {{n}\choose{2}}(1-\tau)}{D=0.5 nC_2(1-\tau)} and the minimum 
number of swaps is the minimum of \eqn{D} and \eqn{N-D}
}
