% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDistribution.R
\name{plotDistribution}
\alias{plotDistribution}
\title{Plot a probability distribution}
\usage{
plotDistribution(
  distribution = c("normal", "t", "chi2", "F"),
  xRange = c(0, 5),
  xColArea = NULL,
  xAreaCol = NULL,
  mean = 0,
  sd = 1,
  df,
  df1,
  df2,
  ncp,
  ...
)
}
\arguments{
\item{distribution}{the probability distribution for which a plot should be drawn. Currently,
the options are \code{"normal", "t", "chi2"} and \code{"F"}.}

\item{xRange}{Range of x axis over which the distribution should be drawn.}

\item{xColArea}{Optional, a matrix with two columns, where each row contains lower and upper bounds
for intervals that should be colored under the pdf curve.}

\item{xAreaCol}{Optional, should contain (a) color(s) for the interval colors in \code{xColArea}.
Defaults to \code{"red"}. Should either be length 1 or length \code{length(xColArea)}.}

\item{mean}{mean for the normal distribution.}

\item{sd}{sd for the normal distribution.}

\item{df}{df for the t distribution.}

\item{df1}{first df for the F distribution.}

\item{df2}{second df for the F distribution.}

\item{ncp}{non-centrality parameter}

\item{...}{other arguments to be forwarded to the \code{plot} function.}
}
\value{
\code{plotDistribution} returns a probability density plot.
}
\description{
Plot the density function of certain probability distributions.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
plotDistribution(distribution = "normal",
                 xRange       = c(-5, 5),
                 xColArea     = matrix(data  = c(-5, -1.96,
                                                 1.96, 5),
                                       ncol  = 2,
                                       byrow = TRUE),
                 xAreaCol     = c("green", "blue"),
                 mean         = 0,
                 sd           = 1,
                 yaxt         = "n",
                 ylab         = "")
}
\author{
Mathijs Deen
}
