% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateUpper.R
\name{estimateUpper}
\alias{estimateUpper}
\title{Estimate Upper Age for MCMCtree analysis}
\usage{
estimateUpper(maxAge, rightTail = 0.025, phy, monoGroups,
  writeMCMCtree = FALSE, MCMCtreeName = "estimateUpper.tre")
}
\arguments{
\item{maxAge}{vector of maximum age bounds for nodes matching order in monoGroups}

\item{rightTail}{probability of right tail (maximum bound default = 0.025)}

\item{phy}{fully resolved phylogeny in ape format}

\item{monoGroups}{list  with each element containing species that define a node of interest}

\item{writeMCMCtree}{logical whether to write tree in format that is compatible with MCMCTree to file}

\item{MCMCtreeName}{MCMCtree.output file name}
}
\value{
list containing node estimates for each distribution
\itemize{
 \item{"parameters"}{ estimated parameters for each node}
 \item{"apePhy"}{ phylogeny in \pkg{APE} format with node labels showing node distributions}
 \item{"MCMCtree"}{ phylogeny in MCMCtree format}
 \item{"nodeLabels"}{ node labels in MCMCtreeR format}
}

If plot=TRUE plot of distributions in file 'pdfOutput' written to current working directory

If writeMCMCtree=TRUE tree in MCMCtree format in file "MCMCtreeName" written to current working directory
}
\description{
Estimate the upper age distribution and output trees for MCMCtree input
}
\examples{
data(apeData)
attach(apeData)
## extract taxon descending from calibrated nodes 8, 10, 11, 13
## these nodes can be visualised using plot.phylo
## and nodelabels from ape
monophyleticGroups <- tipDes(apeData$apeTree, c(8,10,11,13))
minimumTimes <- c("nodeOne"=15, "nodeTwo"=6,
"nodeThree"=8, "nodeFour"=13) / 10
maximumTimes <- c("nodeOne" = 30, "nodeTwo" = 12,
"nodeThree"=12, "nodeFour" = 20) / 10
estimateUpper(maxAge=maximumTimes, monoGroups=monophyleticGroups,
rightTail=0.025, phy=apeTree)
}
\author{
Mark Puttick
}
