% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCtreePhy.R
\name{MCMCtreePhy}
\alias{MCMCtreePhy}
\title{MCMCtreePhy}
\usage{
MCMCtreePhy(phy, minAges, maxAges, monoGroups, method = c("cauchy",
  "upper", "bound", "gamma", "skewNormal", "skewT", "fixed"),
  offset = 0.1, df = 1, shape = 50, scale = 1.5, minProb = 1e-08,
  addMode = 0, maxProb = 0.975, rightTail = 0.025, alpha = 188,
  beta = 100, estimateScale = TRUE, estimateShape = FALSE,
  estimateMode = FALSE, estimateAlpha = TRUE, estimateBeta = FALSE,
  plot = FALSE, pdfOutput = "nodeDistributions.pdf",
  writeMCMCtree = TRUE, MCMCtreeName = "output.tre")
}
\arguments{
\item{phy}{fully resolved phylogeny in ape format}

\item{minAges}{vector of minimum age bounds for nodes matching order in monoGroups}

\item{maxAges}{vector of maximum age bounds for nodes matching order in monoGroups}

\item{monoGroups}{list  with each element containing species that define a node of interest}

\item{method}{vector of the type of calibration distribution for each node}

\item{offset}{offset value for distribution (default = 50)}

\item{df}{degrees of freedom for skew-t distribution (default = 1)}

\item{shape}{shape value for skew-t distribution (default = 50)}

\item{scale}{scale value for distribution (default = 1.5)}

\item{minProb}{probability of left tail (minimum bound) - default to hard minimum (minProb=0)}

\item{addMode}{addition to the minimum age to give the location of the distribution}

\item{maxProb}{probability of right tail (maximum bound. default = 0.975)}

\item{rightTail}{probability of right tail (maximum bound default = 0.025)}

\item{alpha}{alpha value for gamma distribution (default = 188)}

\item{beta}{beta value for gamma distribution (default = 2690)}

\item{estimateScale}{logical specifying whether to estimate scale with a given shape value (default = TRUE)}

\item{estimateShape}{logical specifying whether to estimate shape with a given scale value}

\item{estimateMode}{logical speciftying whether to estimate the scale that produces probabilities of each tail that corresponds roughly to the values given by minProb (lower tail) and maxProb (upper tail)}

\item{estimateAlpha}{logical specifying whether to estimate alpha with a given beta value (default = TRUE)}

\item{estimateBeta}{logical specifying whether to estimate beta with a given alpha value (default = FALSE)}

\item{plot}{logical specifying whether to plot to PDF}

\item{pdfOutput}{pdf output file name}

\item{writeMCMCtree}{logical whether to write tree in format that is compatible with MCMCTree to file}

\item{MCMCtreeName}{MCMCtree.output file name}
}
\value{
list containing node estimates for each distribution
\itemize{
 \item{"parameters"}{ estimated parameters for each node}
 \item{"apePhy"}{ phylogeny in \pkg{APE} format with node labels showing node distributions}
 \item{"MCMCtree"}{ phylogeny in MCMCtree format}
 \item{"nodeLabels"}{ node labels in MCMCtreeR format}
}

If plot=TRUE plot of distributions in file 'pdfOutput' written to current working directory

If writeMCMCtree=TRUE tree in MCMCtree format in file "MCMCtreeName" written to current working directory
}
\description{
Wrapper function to estimate node distributions and add them to tree and output MCMCtree format phylogeny file. If parameter values are in vectors shorter than the number of nodes they are recycled.
}
\examples{
data(apeData)
attach(apeData)
monophyleticGroups <- list()
monophyleticGroups[[1]] <- c("human", "chimpanzee", "bonobo", 
"gorilla", "sumatran", "orangutan", "gibbon")
getMRCA(apeTree, c("human", "chimpanzee", "bonobo", "gorilla"))
monophyleticGroups[[2]] <-#' tipDes(apeTree, 10)
monophyleticGroups[[3]] <- tipDes(apeTree, 11)
monophyleticGroups[[4]] <- c("sumatran", "orangutan")
minimumTimes <- c("nodeOne"=15, "nodeTwo"=6,
"nodeThree"=8, "nodeFour"=13) / 10
maximumTimes <- c("nodeOne" = 30, "nodeTwo" = 12,
"nodeThree"=12, "nodeFour" = 20) / 10
# Cauchy, upper age, bound, and gamma applied individually to each node
MCMCtreePhy(phy=apeTree, minAge=minimumTimes, maxAge=maximumTimes, 
monoGroups=monophyleticGroups, plot=FALSE, 
method=c("cauchy", "upper", "bound", "gamma"), writeMCMCtree=FALSE)
}
