% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.functions.R
\name{timeplot}
\alias{timeplot}
\title{Plot raw responses over time by treatment or class}
\usage{
timeplot(network, level = "treatment", plotby = "arm", link = "identity", ...)
}
\arguments{
\item{network}{An object of class \code{"mb.network"}.}

\item{level}{A string indicating whether nodes/facets should represent \code{treatment}
or \code{class} in the plot. Can be used to examine the expected impact of modelling
class/agent effects.}

\item{plotby}{A character object that can take either \code{"arm"} to indicate that raw responses
should be plotted separately for each study arm, or \code{"rel"} to indicate that the within-study
relative effects/treatment differences should be plotted. In this way the time-course of both the absolute
effects and the relative effects can be examined.}

\item{link}{Can take either \code{"identity"} (the default),
\code{"log"} (for modelling Ratios of Means \insertCite{friedrich2011}{MBNMAtime}) or
\code{"smd"} (for modelling Standardised Mean Differences - although this also corresponds to an identity link function).}

\item{...}{Arguments to be sent to \code{ggplot()}}
}
\value{
The function returns an object of \verb{class(c("gg", "ggplot")}. Characteristics
of the object can therefore be amended as with other plots generated by \code{ggplot()}.
}
\description{
Plot raw responses over time by treatment or class
}
\details{
Plots can be faceted by either treatment (\code{level="treatment"}) or class
(\code{level="class"}) to investigate similarity of treatment responses within classes/agents.
Points represent observed responses and lines connect between observations within the
same study and arm.
}
\examples{
\donttest{
# Make network
goutnet <- mb.network(goutSUA_CFB)

# Use timeplot to plot responses grouped by treatment
timeplot(goutnet)

# Use timeplot ot plot resposes grouped by class
timeplot(goutnet, level="class")

# Plot matrix of relative effects
timeplot(goutnet, level="class", plotby="rel")

# Plot using Standardised Mean Differences
copdnet <- mb.network(copd)
timeplot(copdnet, plotby="rel", link="smd")

}

}
