% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.sum.functions.R
\name{summary.mb.predict}
\alias{summary.mb.predict}
\title{Prints summary of mb.predict object}
\usage{
\method{summary}{mb.predict}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"mb.predict"}}

\item{...}{further arguments passed to or from other methods}
}
\value{
A matrix containing times at which responses have been predicted (\code{time})
and an additional column for each treatment for which responses have been predicted.
Each row represents mean MCMC predicted responses for each treatment at a particular
time.
}
\description{
Prints a summary table of the mean of MCMC iterations at each time point
for each treatment
}
\examples{
\donttest{
# Define network
network <- mb.network(obesityBW_CFB, reference="plac")

# Run an MBNMA with a quadratic time-course function
quad <- mb.quadratic(network,
  beta.1=list(pool="rel", method="common"),
  beta.2=list(pool="rel", method="common"),
  intercept=TRUE)

# Predict responses
pred <- predict(quad, times=c(0:50), treats=c(1:5),
  ref.estimate = network$data.ab[network$data.ab$treatment==1,],
  baseline=10)

# Generate summary of predictions
summary(pred)
}
}
