% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MARX_functions.R
\name{ll.max}
\alias{ll.max}
\title{The value of the t-log-likelihood for MARX function}
\usage{
ll.max(params, y, x, p_C, p_NC)
}
\arguments{
\item{params}{List of parameters.}

\item{y}{Data vector of time series observations.}

\item{x}{Matrix of data (every column represents one time series). Specify NULL or "not" if not wanted.}

\item{p_C}{Number of lags.}

\item{p_NC}{Number of leads.}
}
\value{
\item{neg.loglikelihood}{Minus the loglikelihood.}
}
\description{
This function allows you to determine the value of the t-log-likelihood for the MARX model.
}
\examples{
data <- sim.marx(c('t',1,1), c('t',1,1),100,0.5,0.4,0.3)
y <- data$y
x <- data$x
p_C <- 1
p_NC <- 1
params <- c(0.5,0.4,0.3,0,1,1)
ll.max(params,y,x,p_C,p_NC)
}
\author{
Sean Telg
}
\keyword{optimization}
