% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_03_COMPUTE_PSI_7_Compute_AFE.R
\name{ComputePSI.AFE}
\alias{ComputePSI.AFE}
\title{Compute alternative first exon (AFE) percent spliced-in (PSI) values}
\usage{
ComputePSI.AFE(MarvelObject, CoverageThreshold = 10)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{DetectEvents} function.}

\item{CoverageThreshold}{Numeric value. Coverage threshold below which the PSI of the splicing event will be censored, i.e. annotated as missing (NA). Coverage defined as the total number of reads supporting both included and excluded isoforms.}
}
\value{
An object of class S3 containing with new slots \code{$SpliceFeatureValidated$AFE} and \code{$PSI$AFE}.
}
\description{
Computes percent spliced-in (PSI) for alternative first exon (ALE) splicing events.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- ComputePSI.AFE(MarvelObject=marvel.demo,
                              CoverageThreshold=10
                              )
}
