% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_02_COMPUTE_PSI_2_Compute_MXE.R
\name{ComputePSI.MXE}
\alias{ComputePSI.MXE}
\title{Compute Mutually Exclusive Exons (MXE) Percent Spliced-in (PSI) Values}
\usage{
ComputePSI.MXE(MarvelObject, CoverageThreshold, UnevenCoverageMultiplier = 10)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CreateMarvelObject} function.}

\item{CoverageThreshold}{Numeric value. Coverage threshold below which the PSI of the splicing event will be censored, i.e. annotated as missing (NA). Coverage defined as the total number of reads supporting both included and excluded isoforms.}

\item{UnevenCoverageMultiplier}{Numeric value. Maximum allowable fold difference between two included or two excluded junction counts for MXE.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to two new slots. \code{$SpliceFeatureValidated$MXE} contains the validated splicing event metadata. \code{$PSI$MXE} contains the computed PSI values for the validated splicing events.
}
\description{
\code{ComputePSI.MXE} computes percent spliced-in (PSI) mutually exclusive exons (MXE) splicing event.
}
\details{
This function computes the PSI for each MXE splicing event. Splicing events provided in \code{SpliceFeature} data frame will first be cross-checked against the splice junctions provided in \code{SpliceJunction} data frame. Only events whose junctions are found in \code{SpliceJunction} are retained. The formula for computing PSI is the number of junction reads supporting the included isoform divided by the total number of reads supporting both included and excluded isoforms.
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Run example
marvel <- ComputePSI.MXE(MarvelObject=marvel,
                         CoverageThreshold=10,
                        UnevenCoverageMultiplier=10
                         )

# Check output
marvel$SpliceFeatureValidated$MXE
marvel$PSI$MXE
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
