% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_07_PREDICT_NMD_7_CompareExpr.R
\name{CompareExpr}
\alias{CompareExpr}
\title{Compares Gene Expression Changes based on Nonsense-Mediated Decay (NMD) Status}
\usage{
CompareExpr(MarvelObject, xlabels.size = 8)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{FindPTC} function.}

\item{xlabels.size}{Numeric value. Size of the x-axis tick labels. Default is 8.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to one new slot named \code{MarvelObject$NMD$NMD.Expr}.
}
\description{
\code{CompareExpr} compares gene expression changes based on NMD status for each splicing event type.
}
\details{
This function compares gene expression changes in terms of log2(fold change) based on NMD status for each splicing event type.
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Run example
marvel <- CompareExpr(MarvelObject=marvel,
                      xlabels.size=8
                      )

# Check output
marvel$NMD$NMD.Expr$Table[1:5, ]
marvel$NMD$NMD.Expr$Plot
marvel$NMD$NMD.Expr$Plot.Stats
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
