% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdMassSpectrum.R
\name{sdMassSpectrum}
\alias{sdMassSpectrum}
\title{Compute standard-deviation spectra}
\usage{
sdMassSpectrum(l, labels, ...)
}
\arguments{
\item{l}{list, list of MassSpectrum objects.}

\item{labels}{list, list of factors (one for each MassSpectrum object) to do groupwise averaging.}

\item{...}{arguments to be passed to underlying functions (currently only mc.cores is supported).}
}
\value{
Returns a single (no labels given) or a list (labels given) of standard-deviation spectra as MassSpectrum objects.
}
\description{
This is a fork from sgibb's MALDIquant::averageMassSpectra() function.
It is now able to compute "standard-deviation spectra".
}
\examples{
data(Blank2022spec)

sdMassSpectrum(Blank2022spec, labels = names(Blank2022spec))[[1]]
}
