% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterVariance.R
\name{filterVariance}
\alias{filterVariance}
\title{Filter for high variance signals}
\usage{
filterVariance(
  vars,
  method = c("mean", "median", "q25", "q75", "none"),
  verbose = TRUE
)
}
\arguments{
\item{vars}{Numeric vector, variances of signals}

\item{method}{Character, filtering method. One of "mean" (default), "median", "q25", "q75" (25 and 75\% quantile) or "none".}

\item{verbose}{Logical, print logs to console.}
}
\value{
Indices of spectra with a high variance
}
\description{
Filter for high variance signals
}
\examples{
data(Blank2022intmat)
# get variance of each peak
vars <- apply(Blank2022intmat, 2, var)
highVarIndicies <- filterVariance(vars, method = "mean", verbose = TRUE)
}
