% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SurvAppendMatrix.R
\name{SurvAppendMatrix}
\alias{SurvAppendMatrix}
\title{Append Survival Test Outputs}
\usage{
SurvAppendMatrix(work_dir, out_name = "surv_matrix.csv", out_dir = NULL)
}
\arguments{
\item{work_dir}{the directory where the output files of AnalyzeOrthoMCL are located}

\item{out_name}{file name of outputted matrix}

\item{out_dir}{the directory where the outputted matrix is placed}
}
\value{
A csv file containing a matrix with the following columns: OG, p-values, Bonferroni corrected p-values, mean phenotype of OG-containing taxa, mean pheotype of OG-lacking taxa, taxa included in OG, taxa not included in OG
}
\description{
Function used to append all .csv files that are outputted from AnalyzeOrthoMCL into one matrix.
}
\examples{

file <- system.file('extdata', 'outputs', package='MAGNAMWAR')
directory <- paste(file, '/', sep = '')
SurvAppendMatrix(directory)


}
