% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_ROI.R
\name{extract_ROI}
\alias{extract_ROI}
\title{Extract Pixel Values through Circular Region-of-Interests (ROI) from an Image}
\usage{
extract_ROI(object, roi, roi_summary = "mean", plot = FALSE)
}
\arguments{
\item{object}{\linkS4class{RLum.Data.Image}, \link{array} or \link{matrix} (\strong{required}): input image data}

\item{roi}{\link{matrix} (\strong{required}): matrix with three columns containing the centre coordinates
of the ROI (first two columns) and the diameter of the circular ROI. All numbers must by of type \link{integer}
and will forcefully coerced into such numbers using \code{as.integer()} regardless.}

\item{roi_summary}{(\emph{with default}): defines what is returned in the
\code{roi_summary} element; it can be \code{"mean"} (default), \code{"median"}, \code{"sd"} or
\code{"sum"}.
Pixel values are conveniently summarised using the above defined keyword.}

\item{plot}{\link{logical} (\emph{optional}): enable/disable the plot output. Only
the first image frame is shown.}
}
\value{
\linkS4class{RLum.Results} object with the following elements:
\code{..$roi_signals}: a named \link{list} with all ROI values and their coordinates
\code{..$roi_summary}: a \link{matrix} where rows are frames from the image, and columns are different ROI
The element has two attributes: \code{summary} (the method used to summarise pixels) and \code{area} (the pixel area)
\code{..$roi_coord}: a \link{matrix} that can be passed to \link{plot_ROI}

If \code{plot = TRUE} a control plot is returned.
}
\description{
Light-weighted function to extract pixel values from pre-defined regions-of-interest (ROI) from
\linkS4class{RLum.Data.Image}, \link{array} or \link{matrix} objects and provide simple image processing
capacity. The function is limited to circular ROIs.
}
\details{
The function uses a cheap approach to decide whether a pixel lies within
a circle or not. It assumes that pixel coordinates are integer values and
that a pixel centring within the circle is satisfied by:

\deqn{x^2 + y^2 <= (d/2)^2}

where \eqn{x} and \eqn{y} are integer pixel coordinates and \eqn{d} is the integer
diameter of the circle in pixel.
}
\section{Function version}{
 0.1.0
}

\examples{

m <- matrix(runif(100,0,255), ncol = 10, nrow = 10)
roi <- matrix(c(2.,4,2,5,6,7,3,1,1), ncol = 3)
extract_ROI(object = m, roi = roi, plot = TRUE)

}
\seealso{
\linkS4class{RLum.Data.Image}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. extract_ROI(): Extract Pixel Values through Circular Region-of-Interests (ROI) from an Image. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.1. https://r-lum.github.io/Luminescence/
}

\keyword{manip}
