% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLum.Data.Spectrum-class.R
\docType{class}
\name{RLum.Data.Spectrum-class}
\alias{RLum.Data.Spectrum-class}
\title{Class \code{"RLum.Data.Spectrum"}}
\description{
Class for representing luminescence spectra data (TL/OSL/RF).
}
\section{Slots}{

\describe{
\item{\code{recordType}}{Object of class \link{character} containing the type of the curve (e.g. "TL" or "OSL")}

\item{\code{curveType}}{Object of class \link{character} containing curve type, allowed values are
"measured" or "predefined"}

\item{\code{data}}{Object of class \link{matrix} containing spectrum (count) values.
Row labels indicate wavelength/pixel values, column labels are temperature or time values.}

\item{\code{info}}{Object of class \link{list} containing further meta information objects}
}}

\note{
The class should only contain data for a single spectra data set. For
additional elements the slot \code{info} can be used. Objects from this class are automatically
created by, e.g., \link{read_XSYG2R}
}
\section{Objects from the Class}{

Objects can be created by calls of the form \code{set_RLum("RLum.Data.Spectrum", ...)}.
}

\section{Class version}{
 0.5.2
}

\examples{

showClass("RLum.Data.Spectrum")

##show example data
data(ExampleData.XSYG, envir = environment())
TL.Spectrum

##show data matrix
get_RLum(TL.Spectrum)

##plot spectrum
\dontrun{
plot_RLum(TL.Spectrum)
}

}
\seealso{
\linkS4class{RLum}, \linkS4class{RLum.Data}, \link{plot_RLum}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
\keyword{classes}
