% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_CommonDose.R
\name{calc_CommonDose}
\alias{calc_CommonDose}
\title{Apply the (un-)logged common age model after Galbraith et al. (1999) to a
given De distribution}
\usage{
calc_CommonDose(data, sigmab, log = TRUE, ...)
}
\arguments{
\item{data}{\linkS4class{RLum.Results} or \link{data.frame} (\strong{required}):
for \link{data.frame}: two columns with De \code{(data[,1])} and De error \code{(data[,2])}}

\item{sigmab}{\link{numeric} (\emph{with default}):
additional spread in De values.
This value represents the expected overdispersion in the data should the sample be
well-bleached (Cunningham & Walling 2012, p. 100).
\strong{NOTE}: For the logged model (\code{log = TRUE}) this value must be
a fraction, e.g. 0.2 (= 20 \\%). If the un-logged model is used (\code{log = FALSE}),
sigmab must be provided in the same absolute units of the De values (seconds or Gray).}

\item{log}{\link{logical} (\emph{with default}):
fit the (un-)logged central age model to De data}

\item{...}{currently not used.}
}
\value{
Returns a terminal output. In addition an
\linkS4class{RLum.Results} object is returned containing the
following element:

\item{.$summary}{\link{data.frame} summary of all relevant model results.}
\item{.$data}{\link{data.frame} original input data}
\item{.$args}{\link{list} used arguments}
\item{.$call}{\link{call} the function call}

The output should be accessed using the function \link{get_RLum}
}
\description{
Function to calculate the common dose of a De distribution.
}
\details{
\strong{(Un-)logged model}

When \code{log = TRUE} this function
calculates the weighted mean of logarithmic De values. Each of the estimates
is weighted by the inverse square of its relative standard error. The
weighted mean is then transformed back to the dose scale (Galbraith &
Roberts 2012, p. 14).

The log transformation is not applicable if the
De estimates are close to zero or negative. In this case the un-logged model
can be applied instead (\code{log = FALSE}). The weighted mean is then
calculated using the un-logged estimates of De and their absolute standard
error (Galbraith & Roberts 2012, p. 14).
}
\section{Function version}{
 0.1.1
}

\examples{

## load example data
data(ExampleData.DeValues, envir = environment())

## apply the common dose model
calc_CommonDose(ExampleData.DeValues$CA1)

} 

\section{How to cite}{
Burow, C., 2021. calc_CommonDose(): Apply the (un-)logged common age model after Galbraith et al. (1999) to a given De distribution. Function version 0.1.1. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., 2021. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.15. https://CRAN.R-project.org/package=Luminescence
}

\references{
Galbraith, R.F. & Laslett, G.M., 1993. Statistical models for
mixed fission track ages. Nuclear Tracks Radiation Measurements 4, 459-470.

Galbraith, R.F., Roberts, R.G., Laslett, G.M., Yoshida, H. & Olley,
J.M., 1999. Optical dating of single grains of quartz from Jinmium rock
shelter, northern Australia. Part I: experimental design and statistical
models.  Archaeometry 41, 339-364.

Galbraith, R.F. & Roberts, R.G., 2012. Statistical aspects of equivalent dose and error calculation and
display in OSL dating: An overview and some recommendations. Quaternary
Geochronology 11, 1-27.

\strong{Further reading}

Arnold, L.J. & Roberts, R.G., 2009. Stochastic modelling of multi-grain equivalent dose
(De) distributions: Implications for OSL dating of sediment mixtures.
Quaternary Geochronology 4, 204-230.

Bailey, R.M. & Arnold, L.J., 2006. Statistical modelling of single grain quartz De distributions and an
assessment of procedures for estimating burial dose. Quaternary Science
Reviews 25, 2475-2502.

Cunningham, A.C. & Wallinga, J., 2012. Realizing the potential of fluvial archives using robust OSL chronologies.
Quaternary Geochronology 12, 98-106.

Rodnight, H., Duller, G.A.T., Wintle, A.G. & Tooth, S., 2006. Assessing the reproducibility and accuracy
of optical dating of fluvial deposits.  Quaternary Geochronology, 1 109-120.

Rodnight, H., 2008. How many equivalent dose values are needed to
obtain a reproducible distribution?. Ancient TL 26, 3-10.
}
\seealso{
\link{calc_CentralDose}, \link{calc_FiniteMixture},
\link{calc_FuchsLang2001}, \link{calc_MinDose}
}
\author{
Christoph Burow, University of Cologne (Germany)
, RLum Developer Team}
