% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLum-class.R
\docType{class}
\name{RLum-class}
\alias{RLum-class}
\alias{replicate_RLum,RLum-method}
\title{Class \code{"RLum"}}
\usage{
\S4method{replicate_RLum}{RLum}(object, times = NULL)
}
\arguments{
\item{object}{\linkS4class{RLum} (\strong{required}):
an object of class \linkS4class{RLum}}

\item{times}{\link{integer} (\emph{optional}):
number for times each element is repeated element}
}
\description{
Abstract class for data in the package Luminescence
Sublasses are:
}
\details{
\strong{RLum-class}\cr
|\cr
|----\linkS4class{RLum.Data}\cr
|----|-- \linkS4class{RLum.Data.Curve}\cr
|----|-- \linkS4class{RLum.Data.Spectrum}\cr
|----|-- \linkS4class{RLum.Data.Image}\cr
|----\linkS4class{RLum.Analysis}\cr
|----\linkS4class{RLum.Results}
}
\section{Methods (by generic)}{
\itemize{
\item \code{replicate_RLum}: Replication method RLum-objects
}}

\section{Slots}{

\describe{
\item{\code{originator}}{Object of class \link{character} containing the name of the producing
function for the object. Set automatically by using the function \link{set_RLum}.}

\item{\code{info}}{Object of class \link{list} for additional information on the object itself}

\item{\code{.uid}}{Object of class \link{character} for a unique object identifier. This id is
usually calculated using the internal function \code{create_UID()} if the funtion \link{set_RLum}
is called.}

\item{\code{.pid}}{Object of class \link{character} for a parent id. This allows nesting RLum-objects
at will. The parent id can be the uid of another object.}
}}

\note{
\code{RLum} is a virtual class.
}
\section{Objects from the Class}{

A virtual Class: No objects can be created from it.
}

\section{Class version}{
 0.4.0
}

\examples{

showClass("RLum")

}
\seealso{
\linkS4class{RLum.Data}, \linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Data.Spectrum}, \linkS4class{RLum.Data.Image},
\linkS4class{RLum.Analysis}, \linkS4class{RLum.Results}, \link{methods_RLum}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Université Bordeaux Montaigne (France)
} 

\section{How to cite}{
Kreutzer, S. (2019). RLum-class(): Class 'RLum'. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2019). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.0.109. https://CRAN.R-project.org/package=Luminescence
}

\keyword{classes}
