% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLum-class.R
\docType{class}
\name{RLum-class}
\alias{RLum-class}
\alias{replicate_RLum,RLum-method}
\title{Class \code{"RLum"}}
\usage{
\S4method{replicate_RLum}{RLum}(object, times = NULL)
}
\arguments{
\item{object}{an object of class \code{\linkS4class{RLum}} (\bold{required})}

\item{times}{\code{\link{integer}} (optional): number for times each element is repeated
element}
}
\description{
Abstract class for data in the package Luminescence
}
\section{Methods (by generic)}{
\itemize{
\item \code{replicate_RLum}: Replication method RLum-objects
}}

\section{Slots}{

\describe{
\item{\code{originator}}{Object of class \code{\link{character}} containing the name of the producing
function for the object. Set automatically by using the function \code{\link{set_RLum}}.}

\item{\code{info}}{Object of class \code{\link{list}} for additional information on the object itself}

\item{\code{.uid}}{Object of class \code{\link{character}} for a unique object identifier. This id is
usually calculated using the internal function \code{.create_UID()} if the funtion \code{\link{set_RLum}}
is called.}

\item{\code{.pid}}{Object of class \code{\link{character}} for a parent id. This allows nesting RLum-objects
at will. The parent id can be the uid of another object.}
}}

\note{
\code{RLum} is a virtual class.
}
\section{Objects from the Class}{
 A virtual Class: No objects can be created
from it.
}

\section{Class version}{
 0.4.0
}

\examples{

showClass("RLum")

}
\seealso{
\code{\linkS4class{RLum.Data}}, \code{\linkS4class{RLum.Analysis}}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France)
} 

\section{How to cite}{
Kreutzer, S. (2017). RLum-class(): Class 'RLum'. In: Kreutzer, S., Dietze, M., Burow, C., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2017). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.7.3. https://CRAN.R-project.org/package=Luminescence
}

\keyword{classes}
