% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_RLum.Data.Spectrum.R
\name{plot_RLum.Data.Spectrum}
\alias{plot_RLum.Data.Spectrum}
\title{Plot function for an RLum.Data.Spectrum S4 class object}
\usage{
plot_RLum.Data.Spectrum(object, par.local = TRUE, plot.type = "contour",
  optical.wavelength.colours = TRUE, bg.channels, bin.rows = 1,
  bin.cols = 1, rug = TRUE, limit_counts = NULL, xaxis.energy = FALSE,
  legend.text, ...)
}
\arguments{
\item{object}{\code{\linkS4class{RLum.Data.Spectrum}} or \code{\link{matrix}} (\bold{required}): S4
object of class \code{RLum.Data.Spectrum} or a \code{matrix} containing count values of the spectrum.\cr
Please note that in case of a matrix rownames and colnames are set automatically if not provided.}

\item{par.local}{\code{\link{logical}} (with default): use local graphical
parameters for plotting, e.g. the plot is shown in one column and one row.
If \code{par.local = FALSE} global parameters are inherited.}

\item{plot.type}{\code{\link{character}} (with default): plot type, for
3D-plot use \code{persp}, or \code{interactive}, for a 2D-plot \code{contour},
\code{single} or \code{multiple.lines} (along the time or temperature axis)
or \code{transect} (along the wavelength axis) \cr}

\item{optical.wavelength.colours}{\code{\link{logical}} (with default): use
optical wavelength colour palette. Note: For this, the spectrum range is
limited: \code{c(350,750)}. Own colours can be set with the argument
\code{col}.}

\item{bg.channels}{\code{\link{vector}} (optional): defines channel for
background subtraction If a vector is provided the mean of the channels is
used for subtraction. Note: Background subtraction is applied prior to
channel binning}

\item{bin.rows}{\code{\link{integer}} (with defaul): allow summing-up
wavelength channels (horizontal binning), e.g. \code{bin.rows = 2} two
channels are summed up}

\item{bin.cols}{\code{\link{integer}} (with default): allow summing-up
channel counts (vertical binning) for plotting, e.g. \code{bin.cols = 2} two
channels are summed up}

\item{rug}{\code{\link{logical}} (with default): enables or disables colour
rug. Currently only implemented for plot type \code{multiple.lines} and
\code{single}}

\item{limit_counts}{\code{\link{numeric}} (optional): value to limit all count values to
this value, i.e. all count values above this threshold will be replaced by this threshold. This
is helpfull especially in case of TL-spectra.}

\item{xaxis.energy}{\code{\link{logical}} (with default): enables or
disables energy instead of wavelength axis. Note: This option means not only
simnply redrawing the axis, insteadly the spectrum in terms of intensity is
recalculated, s. details.}

\item{legend.text}{\code{\link{character}} (with default): possiblity to
provide own legend text. This argument is only considered for plot types
providing a legend, e.g. \code{plot.type="transect"}}

\item{\dots}{further arguments and graphical parameters that will be passed
to the \code{plot} function.}
}
\value{
Returns a plot.
}
\description{
The function provides a standardised plot output for spectrum data of an
RLum.Data.Spectrum S4 class object
}
\details{
\bold{Matrix structure} \cr (cf. \code{\linkS4class{RLum.Data.Spectrum}})

\itemize{ \item \code{rows} (x-values): wavelengths/channels (xlim, xlab)
\item \code{columns} (y-values): time/temperature (ylim, ylab) \item
\code{cells} (z-values): count values (zlim, zlab) }

\emph{Note: This nomenclature is valid for all plot types of this
function!}\cr

\bold{Nomenclature for value limiting}

\code{xlim}: Limits values along the wavelength axis\cr \code{ylim}: Limits
values along the time/temperature axis\cr \code{zlim}: Limits values along
the count value axis\cr

\bold{Energy axis re-calculation}

If the argument \code{xaxis.energy = TRUE} is chosen, instead intensity vs.
wavelength the spectrum is plotted as intensiyt vs. energy. Therefore the
entire spectrum is re-recaluated (e.g., Appendix 4 in Blasse and Grabmeier,
1994):

The intensity of the spectrum (z-values) is re-calcualted using the
following equation:

\deqn{\phi_{E} = \phi_{\lambda} * \lambda^2 / (hc)}

with \eqn{\phi_{E}} the intensity per interval of energy \eqn{E} (eV),
\eqn{\phi_{\lambda}} the intensity per interval of wavelength \eqn{\lambda}
(nm) and \eqn{h} (eV/s) the Planck constant and \eqn{c} (m/s) the velocity
of light.

For transforming the wavelength axis (x-values) the equation

\deqn{E = hc/\lambda}

is used. For further details please see the cited the literature.\cr

\bold{Details on the plot functions}

Spectrum is visualised as 3D or 2D plot. Both plot types are based on
internal R plot functions. \cr

\bold{\code{plot.type = "persp"}}

Arguments that will be passed to \code{\link{persp}}: \itemize{ \item
\code{shade}: default is \code{0.4} \item \code{phi}: default is \code{15}
\item \code{theta}: default is \code{-30} \item \code{expand}: default is
\code{1} \item \code{ticktype}: default is \code{detailed}, \code{r}: default is \code{10}}

\emph{Note: Further parameters can be adjusted via \code{par}. For example
to set the background transparent and reduce the thickness of the lines use:
\code{par(bg = NA, lwd = 0.7)} previous the function call.}

\bold{\code{plot.type = "single"}}\cr

Per frame a single curve is returned. Frames are time or temperature
steps.\cr

\bold{\code{plot.type = "multiple.lines"}}\cr

All frames plotted in one frame.\cr

\bold{\code{plot.type = "transect"}}\cr

Depending on the selected wavelength/channel range a transect over the
time/temperature (y-axis) will be plotted along the wavelength/channels
(x-axis). If the range contains more than one channel, values (z-values) are
summed up. To select a transect use the \code{xlim} argument, e.g.
\code{xlim = c(300,310)} plot along the summed up count values of channel
300 to 310.\cr

\bold{Further arguments that will be passed (depending on the plot type)}

\code{xlab}, \code{ylab}, \code{zlab}, \code{xlim}, \code{ylim},
\code{zlim}, \code{main}, \code{mtext}, \code{pch}, \code{type} ("single", "multiple.lines",
"interactive"), \code{col},
\code{border}, \code{box} \code{lwd}, \code{bty}, \code{showscale} ("interactive") \cr
}
\note{
Not all additional arguments (\code{...}) will be passed similarly!
}
\section{Function version}{
 0.5.2 (2017-01-24 21:10:47)
}

\examples{


##load example data
data(ExampleData.XSYG, envir = environment())

##(1)plot simple spectrum (2D) - contour
plot_RLum.Data.Spectrum(TL.Spectrum,
                        plot.type="contour",
                        xlim = c(310,750),
                        ylim = c(0,300),
                        bin.rows=10,
                        bin.cols = 1)

##(2) plot spectrum (3D)
plot_RLum.Data.Spectrum(TL.Spectrum,
                        plot.type="persp",
                        xlim = c(310,750),
                        ylim = c(0,100),
                        bin.rows=10,
                        bin.cols = 1)

##(3) plot multiple lines (2D) - multiple.lines (with ylim)
plot_RLum.Data.Spectrum(TL.Spectrum,
                        plot.type="multiple.lines",
                        xlim = c(310,750),
                        ylim = c(0,100),
                        bin.rows=10,
                        bin.cols = 1)

\dontrun{
 ##(4) interactive plot using the package plotly ("surface")
 plot_RLum.Data.Spectrum(TL.Spectrum, plot.type="interactive",
 xlim = c(310,750), ylim = c(0,300), bin.rows=10,
 bin.cols = 1)

 ##(5) interactive plot using the package plotly ("contour")
 plot_RLum.Data.Spectrum(TL.Spectrum, plot.type="interactive",
 xlim = c(310,750), ylim = c(0,300), bin.rows=10,
 bin.cols = 1,
 type = NULL,
 showscale = TRUE)

 ##(6) alternative using the package fields
 fields::image.plot(get_RLum(TL.Spectrum))
 contour(get_RLum(TL.Spectrum), add = TRUE)

}

} 

\section{How to cite}{
Kreutzer, S. (2017). plot_RLum.Data.Spectrum(): Plot function for an RLum.Data.Spectrum S4 class object. Function version 0.5.2. In: Kreutzer, S., Dietze, M., Burow, C., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2017). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.7.1. https://CRAN.R-project.org/package=Luminescence
}

\references{
Blasse, G., Grabmaier, B.C., 1994. Luminescent Materials.
Springer.
}
\seealso{
\code{\linkS4class{RLum.Data.Spectrum}}, \code{\link{plot}},
\code{\link{plot_RLum}}, \code{\link{persp}}, \code{\link[plotly]{plot_ly}},
\code{\link{contour}}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
\cr R Luminescence Package Team}
\keyword{aplot}
