\name{ExampleData.CW_OSL_Curve}
\alias{ExampleData.CW_OSL_Curve}
\docType{data}
\title{
Example CW-OSL curve data for package Luminescence
}
\description{
\code{data.frame} containing CW-OSL curve data (time, counts)
}
\usage{data(ExampleData.CW_OSL_Curve)}
\format{
  Data frame with 1000 observations on the following 2 variables.
  \describe{
    \item{\code{x}}{a numeric vector, time}
    \item{\code{y}}{a numeric vector, counts}
  }
}
\details{
see source
%%  ~~ If necessary, more details than the __description__ above ~~
}
\source{
\bold{ExampleData.CW_OSL_Curve}

\tabular{ll}{
Lab: \tab Luminescence Laboratory Bayreuth\cr
Lab-Code: \tab BT607\cr
Location: \tab Saxony/Germany\cr
Material: \tab Middle grain quartz measured on aluminum cups on a Risoe DA-15 reader.\cr
Reference: \tab unpublished data 
}

\bold{CW_Curve.BosWallinga2012}

\tabular{ll}{
Lab: \tab Netherlands Centre for Luminescence Dating (NCL)\cr
Lab-Code: \tab NCL-2108077\cr
Location: \tab  Guadalentin Basin, Spain\cr
Material: \tab Coarse grain quartz.\cr
Reference: \tab Bos & Wallinga (2012) and Baartman et al. (2011) 
}

%%  ~~ reference to a publication or URL from which the data were obtained ~~
}
\references{
Baartman, J.E.M., Veldkamp, A., Schoorl, J.M., Wallinga, J., Cammeraat, L.H., 2011. Unravelling Late Pleistocene and Holocene landscape dynamics: The Upper Guadalentin Basin, SE Spain. Geomorphology, 125, pp. 172-185.

Bos, A.J.J. & Wallinga, J., 2012. How to visualize quartz OSL signal components. Radiation Measurements, 47, pp. 752-758.

%%  ~~ possibly secondary sources and usages ~~
}
\examples{
data(ExampleData.CW_OSL_Curve, envir = environment())
plot(ExampleData.CW_OSL_Curve) 
}
\keyword{datasets}
