\name{eval.logreg}
\alias{eval.logreg}
\title{Evaluate a Logic Regression tree}


\description{This function evaluates a logic tree, typically a part
of an object generated by \code{logreg}.}


\usage{eval.logreg(ltree, data)}


\arguments{

\item{ltree}{an object of class \code{logregmodel} or an object of class
\code{logregtree}.
Typically this object will be part of the result of an object of class
\code{logreg}, generated with \code{select = 1} (single model fit),
\code{select = 2} (multiple model fit), or
\code{select = 6} (greedy stepwise fit).}

\item{data}{a data frame on which the logic tree is to be
evaluated. \code{data} should be binary, and have the same number of
columns as the \code{bin} component of the original \code{logreg}
fit.}
}


\value{A binary vector with length equal to the number of rows of
\code{data}; a 1 corresponds to cases for which \code{ltree} was
\code{TRUE} and a 0 corresponds to cases for which  \code{ltree} was
\code{FALSE} if \code{ltree} was an object of class \code{logregtree}
or the \code{trees} component of such an object. Otherwise a matrix
with one column for each tree in \code{ltree}.}


\references{

Ruczinski I, Kooperberg C, LeBlanc ML (2003).  Logic Regression,
\emph{Journal of Computational and Graphical Statistics}, \bold{12}, 475-511.

Ruczinski I, Kooperberg C, LeBlanc ML (2002).  Logic Regression -
methods and software.  \emph{Proceedings of the MSRI workshop on
Nonlinear Estimation and Classification} (Eds: D. Denison, M. Hansen,
C. Holmes, B. Mallick, B. Yu), Springer: New York, 333-344.
}


\author{
Ingo Ruczinski \email{ingo@jhu.edu} and
Charles Kooperberg \email{clk@fhcrc.org}}


\seealso{
\code{\link{logreg}},
\code{\link{logregtree}},
\code{\link{logregmodel}},
\code{\link{frame.logreg}},
\code{\link{logreg.testdat}}
}


\examples{
data(logreg.savefit1)
# myanneal <- logreg.anneal.control(start = -1, end = -4, iter = 25000, update = 1000)
# logreg.savefit1 <- logreg(resp = logreg.testdat[,1], bin=logreg.testdat[, 2:21], 
#                type = 2, select = 1, ntrees = 2, anneal.control = myanneal)
tree1 <- eval.logreg(logreg.savefit1$model$trees[[1]], logreg.savefit1$binary)
tree2 <- eval.logreg(logreg.savefit1$model$trees[[2]], logreg.savefit1$binary)
alltrees <- eval.logreg(logreg.savefit1$model, logreg.savefit1$binary)
}


\keyword{logic}
\keyword{methods}
\keyword{nonparametric}
\keyword{tree}

