% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.fasta.R
\name{write.fasta}
\alias{write.fasta}
\title{Write FASTA Files}
\usage{
write.fasta(names, sequences, file)
}
\arguments{
\item{names}{A character vector of sequence names.}

\item{sequences}{A character vector of sequences.}

\item{file}{A string specifying the path to a FASTA file to write.}
}
\value{
No return value. Writes a FASTA file.
}
\description{
Writes FASTA files.
}
\examples{
# Get path to example sequences CSV file.
path_to_CSV_file<-system.file("extdata",
                              "example_query_sequences.csv",
                              package="LocaTT",
                              mustWork=TRUE)

# Read the example sequences CSV file.
df<-read.csv(file=path_to_CSV_file,stringsAsFactors=FALSE)

# Create a temporary file path for the FASTA file to write.
path_to_FASTA_file<-tempfile(fileext=".fasta")

# Write the example sequences as a FASTA file.
write.fasta(names=df$Name,
            sequences=df$Sequence,
            file=path_to_FASTA_file)
}
\seealso{
\code{\link[=read.fasta]{read.fasta}} for reading FASTA files. \cr
\code{\link[=write.fastq]{write.fastq}} for writing FASTQ files. \cr
\code{\link[=read.fastq]{read.fastq}} for reading FASTQ files.
}
