% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subfunctionsIdentification.R
\name{organizeResults}
\alias{organizeResults}
\title{Prepare output for LipidMS annotation functions}
\usage{
organizeResults(
  candidates,
  clfrags,
  classConf,
  chainsComb,
  intrules,
  intConf,
  nchains,
  class,
  acquisitionmode
)
}
\arguments{
\item{candidates}{candidates data frame. Output of \link{findCandidates}.}

\item{clfrags}{vector containing the expected fragments for a given lipid
class.}

\item{classConf}{output of \link{checkClass}}

\item{chainsComb}{output of \link{combineChains}}

\item{intrules}{character vector specifying the fragments to compare. See
\link{checkIntensityRules}.}

\item{intConf}{output of \link{checkIntensityRules}}

\item{nchains}{number of chains of the targeted lipid class.}

\item{class}{character value. Lipid class (i.e. PC, PE, DG, TG, etc.).}

\item{acquisitionmode}{acquisition mode (DIA or DDA).}
}
\description{
Prepare a readable output for LipidMS identification functions.
}
\details{
Coelution score for DIA data is calculated as the mean coelution 
score of all fragments used for annotation, while for DDA data, it is 
calculated as the sum relative intensity of those fragments in theie MS2 scan.
}
\examples{
\dontrun{
devtools::install_github("maialba3/LipidMSdata2")

library(LipidMS)
dbs <- assignDB()

MS1 <- LipidMSdata2::msobjectDIAneg$peaklist$MS1
MS1 <- MS1[MS1$isotope \%in\% c("[M+0]"), !colnames(MS1) \%in\% c("isotope", "isoGroup")]
MS2 <- LipidMSdata2::msobjectDIAneg$peaklist$MS2[,c("mz", "RT", "int", "peakID")]
rawData <- rbind(LipidMSdata2::msobjectDIAneg$MS1, LipidMSdata2::msobjectDIAneg$MS2)

candidates <- findCandidates(MS1 = MS1, db = dbs$pgdb, ppm = 10,
rt = c(0, 2000), adducts = c("M-H"), rttol = 10, dbs = dbs,
rawData = rawData, coelCutoff = 0.8)
coelfrags <- coelutingFrags(candidates, MSMS, rttol = 10, rawData = rawData,
coelCutoff = 0.8)
classConf <- checkClass(candidates, coelfrags,
clfrags = c(227.0326, 209.022, 74.0359),
clrequisites = c(FALSE, FALSE, FALSE, FALSE),
ftype = c("F", "F", "NL"), ppm = 10, dbs = dbs)
sn1 <- chainFrags(coelfrags, chainfrags = c("lysopg_M-H"),
candidates = candidates, ppm = 10, dbs = dbs)
sn2 <- chainFrags(coelfrags, chainfrags = c("fa_M-H"), ppm = 10,
candidates = candidates, dbs = dbs)
chainsComb <- combineChains(candidates, nchains=2, sn1, sn2)
intConf <- checkIntensityRules(intrules = c("lysopg_sn1/lysopg_sn1"),
rates = c("2/1"), intrequired = c(TRUE), nchains=2, chainsComb)

res <- organizeResults(candidates, clfrags = c(227.0326, 209.022, 74.0359),
classConf, chainsComb, intrules = c("lysopg_sn1/lysopg_sn1"), intConf,
nchains = 2, class="PG", acquisitionmode = "DIA")
}

}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
