% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigenvalues.R
\name{eigenvalues}
\alias{eigenvalues}
\title{calculate eigenvalues of a correlation matrix with optional scree plot}
\usage{
eigenvalues(cormatrix, scree = FALSE)
}
\arguments{
\item{cormatrix}{(real, matrix) a correlation matrix}

\item{scree}{(logical) default = \code{FALSE}. If \code{TRUE} (or \code{1}), then
\code{eigenvalues()} produces a scree plot to illustrate the eigenvalues}
}
\value{
a vector of eigenvalues

report on positive-definite status of cormatrix
}
\description{
\code{eigenvalues()} calculate eigenvalues of a correlation
matrix and optionally produces a scree plot.
}
\examples{

## define parameters

correlationMatrix <- matrix(
  c(
    1.00, 0.25, 0.35, 0.40,
    0.25, 1.00, 0.70, 0.75,
    0.35, 0.70, 1.00, 0.80,
    0.40, 0.75, 0.80, 1.00
  ),
  nrow = 4, ncol = 4
)

## apply function

evals <- eigenvalues(cormatrix = correlationMatrix)
evals <- eigenvalues(correlationMatrix, 1)

}
