% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric_nvR.R
\name{nvRC_metrics}
\alias{nvRC_metrics}
\alias{nvRC_circadianDisturbance}
\alias{nvRC_circadianBias}
\alias{nvRC_relativeAmplitudeError}
\title{Performance metrics for circadian response}
\usage{
nvRC_circadianDisturbance(nvRC, nvRC.ref, as.df = FALSE)

nvRC_circadianBias(nvRC, nvRC.ref, as.df = FALSE)

nvRC_relativeAmplitudeError(nvRC, nvRC.ref, as.df = FALSE)
}
\arguments{
\item{nvRC}{Time series of non-visual circadian response
(see \code{\link{nvRC}}.}

\item{nvRC.ref}{Time series of non-visual circadian response
circadian response (see \code{\link{nvRC}} for a reference light exposure
pattern (e.g., daylight). Must be the same length as \code{nvRC}.}

\item{as.df}{Logical. Should the output be returned as a data frame? Defaults
to TRUE.}
}
\value{
A numeric value or single column data frame.
}
\description{
These functions compare the non-visual circadian response (see \code{\link{nvRC}})
for measured personal light exposure to the nvRC for a reference light exposure pattern,
such as daylight.
}
\details{
\code{nvRC_circadianDisturbance()} calculates the circadian disturbance (CD).
It is expressed as

\deqn{CD(i,T)=\frac{1}{T}\int_{t_{i}}^{t_{i}+T}
   {\lvert r_{C}(t)-r_{C}^{ref}(t)\rvert dt},}

and quantifies the total difference between the measured circadian response
and the circadian response to a reference profile.

\code{nvRC_circadianBias()} calculates the circadian bias (CB).
It is expressed as

\deqn{CB(i,T)=\frac{1}{T}\int_{t_{i}}^{t_{i}+T}
   {(r_{C}(t)-r_{C}^{ref}(t))dt},}

and provides a measure of the overall trend for the difference in
circadian response, i.e. positive values for overestimating and negative
for underestimating between the measured circadian response
and the circadian response to a reference profile.

\code{nvRC_relativeAmplitudeError()} calculates the relative amplitude error (RAE).
It is expressed as

\deqn{RAE(i,T)=r_{C,max}-r_{C,max}^{ref},}

and quantifies the difference between the maximum response achieved in a period
to the reference signal.
}
\examples{

dataset1 <- 
  tibble::tibble(
    Id = rep("B", 60 * 24),
    Datetime = lubridate::as_datetime(0) + lubridate::minutes(0:(60*24-1)),
    Illuminance = c(rep(0, 60*8), rep(sample(1:1000, 16, replace = TRUE), each = 60)),
    MEDI = Illuminance * rep(sample(0.5:1.5, 24, replace = TRUE), each = 60),
  ) \%>\%
  dplyr::mutate(
    nvRC = nvRC(MEDI, Illuminance, Datetime, sleep.onset = hms::as_hms("22:00:00"))
  )

dataset.reference <-
  tibble::tibble(
    Id = rep("Daylight", 60 * 24),
    Datetime = lubridate::as_datetime(0) + lubridate::minutes(0:(60*24-1)),
    Illuminance = c(rep(0, 60*6), rep(10000, 12*60), rep(0, 60*6)),
    MEDI = Illuminance
  ) \%>\%
  dplyr::mutate(
    nvRC = nvRC(MEDI, Illuminance, Datetime, sleep.onset = hms::as_hms("22:00:00"))
  )

# Circadian disturbance
nvRC_circadianDisturbance(dataset1$nvRC, dataset.reference$nvRC)

# Circadian bias
nvRC_circadianBias(dataset1$nvRC, dataset.reference$nvRC)

# Relative amplitude error
nvRC_relativeAmplitudeError(dataset1$nvRC, dataset.reference$nvRC)
}
\references{
Amundadottir, M.L. (2016). Light-driven model for identifying
indicators of non-visual health potential in the built environment
[Doctoral dissertation, EPFL]. EPFL infoscience.
\doi{10.5075/epfl-thesis-7146}
}
