% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cv.lb.R
\name{cv.lb}
\alias{cv.lb}
\title{CV for lb}
\usage{
cv.lb(X, y, kappa, alpha, K = 5, t, family = c("gaussian", "binomial",
  "multinomial"), group.type = c("ungrouped", "grouped", "columned"),
  intercept = TRUE, normalize = TRUE, plot.it = TRUE, se = TRUE, ...)
}
\arguments{
\item{X}{An n-by-p matrix of predictors}

\item{y}{Response Variable}

\item{kappa}{The damping factor of the Linearized Bregman Algorithm that is
defined in the reference paper. See details.}

\item{alpha}{Parameter in Linearized Bregman algorithm which controls the
step-length of the discretized solver for the Bregman Inverse Scale Space.
See details.}

\item{K}{Folds number for CV. Default is 5.}

\item{t}{A vector of predecided tuning parameter.}

\item{family}{Response type}

\item{group.type}{There are three kinds of group type. "Column" is only
available for multinomial model.}

\item{intercept}{If TRUE, an intercept is included in the model (and not
penalized), otherwise no intercept is included. Default is TRUE.}

\item{normalize}{if TRUE, each variable is scaled to have L2 norm
square-root n. Default is TRUE.}

\item{plot.it}{Plot it? Default is TRUE}

\item{se}{Include standard error bands? Default is TRUE}

\item{\dots}{Additonal arguments passing to lb}
}
\value{
A list is returned. The list contains a vector of parameter t,
crossvalidation error cv.error, and the estimated standard deviation for it cv.sd
}
\description{
Cross-validation method to tuning the parameter $t$ for lb.
}
\details{
K-fold cross-validation method is used to tuning the parameter $t$ for ISS.
Mean square error is used for linear model. Miss-classification error
is used for binomial and multinomial model.
}
\examples{
#Examples in the reference paper
library(MASS)
n = 200;p = 100;k = 30;sigma = 1
Sigma = 1/(3*p)*matrix(rep(1,p^2),p,p)
diag(Sigma) = 1
A = mvrnorm(n, rep(0, p), Sigma)
u_ref = rep(0,p)
supp_ref = 1:k
u_ref[supp_ref] = rnorm(k)
u_ref[supp_ref] = u_ref[supp_ref]+sign(u_ref[supp_ref])
b = as.vector(A\%*\%u_ref + sigma*rnorm(n))
cv.lb(A,b,10,1/20,intercept = FALSE,normalize = FALSE,iter=300)

#Simulated data, binomial case
X <- matrix(rnorm(1000*256), nrow=1000, ncol=256)
alpha <- c(rep(1,50), rep(0,206))
y <- 2*as.numeric(runif(1000)<1/(1+exp(-X \%*\% alpha)))-1
cv.lb(X,y,kappa=5,alpha=1,family="binomial",
             intercept=FALSE,normalize = FALSE,iter=300)
}
\author{
Feng Ruan, Jiechao Xiong and Yuan Yao
}
\references{
Ohser, Ruan, Xiong, Yao and Yin, Sparse Recovery via Differential
 Inclusions, \url{http://arxiv.org/abs/1406.7728}
}
\keyword{Cross-validation}

