% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FractalSegment.R
\name{FractalSegment}
\alias{FractalSegment}
\title{Plots a fractal curve starting from a segment}
\usage{
FractalSegment(P1, P2, angle, cut1, cut2, f, it)
}
\arguments{
\item{P1}{Vector containing the xy-coordinates of point 1. This point is the left extreme of the segment that corresponds to the first iteration (\code{it} = 1)}

\item{P2}{Vector containing the xy-coordinates of point 2. This point is the right extreme of the segment that corresponds to the first iteration (\code{it} = 1)}

\item{angle}{Angle (0-360) that determines the angle with which the new segments are drawn at the cut points}

\item{cut1}{Number bigger than 0 and smaller than 1 that indicates the proportional part of the segment at which the first cut occurs. This parameter determines the position of the first cut point}

\item{cut2}{Number bigger than 0 and smaller than 1 that indicates the proportional part of the segment at which the second cut occurs. This parameter determines the position of the second cut point}

\item{f}{Positive number that produces an enlargement or a reduction for the new drawn segment in each iteration}

\item{it}{Number of iterations to be performed for the construction of the fractal curve. It is not recommended to choose a number higher than 7 in order to avoid an excess of computation}
}
\value{
None. It produces the plot of the first \code{n} iterations of a fractal curve in the current coordinate plane. The choice of parameters \code{cut1 = 1/3}, \code{cut2 = 2/3}, \code{angle = 60} and \code{f = 1} produces the Koch curve
}
\description{
\code{FractalSegment} plots the first iterations of a fractal curve, starting from a segment in the plane
}
\examples{
x_min <- -6
x_max <- 6
y_min <- -4
y_max <- 8
CoordinatePlane(x_min, x_max, y_min, y_max)
P1 <- c(-5,0)
P2 <- c(5,0)
angle <- 90
cut1 <- 1/3
cut2 <- 2/3
f <- 1
it <- 4
FractalSegment(P1, P2, angle, cut1, cut2, f, it)
}
\references{
http://mathworld.wolfram.com/Fractal.html
}
