% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LagLaplaceDeconvolution.R
\name{LaplaceConvolution}
\alias{LaplaceConvolution}
\title{function LaplaceConvolution}
\usage{
LaplaceConvolution(t, g, f)
}
\arguments{
\item{t,}{numeric vector, the observation times}

\item{g,}{numeric vector, the observed values of the known Laplace convolution kernel at the observation times}

\item{f,}{numeric vector, the coefficients the values of the function f to convole with g}
}
\value{
return the Laplace convolution of f and g using Trapezoidal formula and spline approximation for F
}
\description{
computes the Laplace convolution of two functions f and g observed at discrete times t. Use trapezoidal formula and spline approximation of f.
}
\examples{
\dontrun{

 library(LaplaceDeconv)
 t = seq(0,10,l=100)
 g = exp(-5*t)
 f = t^2*exp(-t)
 # compute the Laplace convolution from functions computed at times t : f and g
 fg = LaplaceConvolution(t,g,f)
 matplot(t,cbind(f,g,fg),lty=1,type='l')
 legend('topright',lty=1,legend=c('f','g','fxg'),col=1:3)
 }
}
\author{
Y. Rozenholc and M. Pensky
}

