% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xexp.R
\name{xexp}
\alias{deriv_xexp}
\alias{xexp}
\title{Transformation that defines the Lambert W function and its derivative}
\usage{
xexp(x)

deriv_xexp(x, degree = 1)
}
\arguments{
\item{x}{a numeric vector of real/complex values.}

\item{degree}{non-negative integer; degree of the derivative}
}
\value{
Returns \eqn{z = x \exp(x)} for \eqn{x \in C}. If \eqn{x} is a
vector/matrix, so is \eqn{z}.
}
\description{
The Lambert W function \eqn{W(z)} is the inverse of \eqn{u \exp(u) = z}.

In versions < 0.6.0 of the package this function was denoted as \code{H}. 
It is now replaced with the more descriptive \code{xexp} (and \code{H}
is deprecated).
}
\details{
The n-th derviative of \eqn{x \cdot \exp(x)} is available in closed for as

\deqn{ \exp(x) \cdot (x + n).}
}
\examples{

plot(xexp, -5, 0.5, type="l", xlab="u", ylab="z")
grid()
abline(h=0, lty = 2)
abline(v=0, lty = 2)

}
\seealso{
\code{\link{W}}
}
\keyword{math}

