% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpm_g.R
\name{tpm_g}
\alias{tpm_g}
\title{Build all transition probability matrices of an inhomogeneous HMM}
\usage{
tpm_g(Z, beta, byrow = FALSE)
}
\arguments{
\item{Z}{Covariate design matrix (excluding intercept column) of dimension c(n, p), where p can also be one (i.e. Z can be a vector).}

\item{beta}{Matrix of coefficients for the off-diagonal elements of the transition probability matrix.
Needs to be of dimension c(N*(N-1), p+1), where the first column contains the intercepts.}

\item{byrow}{Logical that indicates if each transition probability matrix should be filled by row. 
Defaults to FALSE, but should be set to TRUE if one wants to work with a matrix of beta parameters returned by popular HMM packages like moveHMM, momentuHMM, or hmmTMB.}
}
\value{
Array of transition probability matrices of dimension c(N,N,n)
}
\description{
In an HMM, we can model the influence of covariates on the state process, by linking them to the transition probabiltiy matrix. 
Most commonly, this is done by specifying a linear predictor \cr \cr
\eqn{ \eta_{ij}^{(t)} = \beta^{(ij)}_0 + \beta^{(ij)}_1 z_{t1} + \dots + \beta^{(ij)}_p z_{tp} } \cr \cr
for each off-diagonal element (\eqn{i \neq j}) and then applying the inverse multinomial logistic link to each row.
This function efficiently calculates all transition probabilty matrices for a given design matrix \eqn{Z} and parameter matrix beta.
}
\examples{
n = 1000
Z = matrix(runif(n*2), ncol = 2)
beta = matrix(c(-1, 1, 2, -2, 1, -2), nrow = 2, byrow = TRUE)
Gamma = tpm_g(Z, beta)
}
