% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LVGP_predict.R
\name{LVGP_predict}
\alias{LVGP_predict}
\title{The Prediction Function of \code{LVGP} Package}
\usage{
LVGP_predict(X_new, model, MSE_on = 0)
}
\arguments{
\item{X_new}{Matrix or vector containing the input(s) where the predictions are to be made. Each row is an input vector.}

\item{model}{The LVGP model fitted by \code{\link[LVGP]{LVGP_fit}}.}

\item{MSE_on}{A scalar indicating whether the uncertainty (i.e., mean squared error \code{MSE}) is calculated.
Set to a non-zero value to calculate \code{MSE}.}
}
\value{
A prediction list containing the following components:
\itemize{
\item{\code{Y_hat}} {A vector containing the mean prediction values}
\item{\code{MSE}} {A vector containing the prediction uncertainty (i.e., the covariance or covariance matrix for the output(s) at prediction location(s)) }
}
}
\description{
Predicts the output and associated uncertainties of the GP model fitted by \code{\link[LVGP]{LVGP_fit}}.
}
\examples{
# see the examples in the documentation of the function LVGP_fit.
}
\references{
\enumerate{
\item "A Latent Variable Approach to Gaussian Process Modeling with Qualitative and Quantitative Factors", Yichi Zhang, Siyu Tao, Wei Chen, and Daniel W. Apley (\href{https://arxiv.org/abs/1806.07504}{arXiv})
}
}
\seealso{
\code{\link[LVGP]{LVGP_fit}} to fit LVGP model to the datasets.\cr
\code{\link[LVGP]{LVGP_plot}} to plot the features of the fitted model.
}
