% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_lucid.R
\name{tune.lucid}
\alias{tune.lucid}
\title{Grid search for tuning parameters to fit the LUCID model}
\usage{
tune.lucid(
  G,
  Z,
  Y,
  CoG = NULL,
  CoY = NULL,
  family = "normal",
  useY = TRUE,
  K = 2:6,
  Rho_G = NULL,
  Rho_Z_InvCov = NULL,
  Rho_Z_CovMu = NULL
)
}
\arguments{
\item{G}{Genetic features/environmental exposures, a \code{\link{matrix}}.}

\item{Z}{Biomarkers/other omics data, a \code{\link{matrix}}.}

\item{Y}{Disease outcome, it is suggested to transform it into a n by 1 \code{\link{matrix}}.}

\item{CoG}{Optional, matrix. Covariates to be adjusted for estimating the latent cluster.}

\item{CoY}{Optional, matrix. Covariates to be adjusted for estimating the outcome.}

\item{family}{Type of outcome Y. It should be choose from "normal", "binary".}

\item{useY}{Whether or not to include the information of Y to estimate the latent clusters. Default is TRUE.}

\item{K}{Numeric sequence. Number of latent clusters.}

\item{Rho_G}{Numeric sequence, Lasso type penalty for selection of G.}

\item{Rho_Z_InvCov}{Numeric sequence, Lasso type penalty for the inverse covariance structure of Z.}

\item{Rho_Z_CovMu}{Numeric sequence, Lasso type penalty for the product of covariance matrix and mean of Z}
}
\value{
A list. Containing model BICs of different combination of tuning parameters.
}
\description{
Grid search for tuning parameters to fit the LUCID model
}
\examples{
\dontrun{
tuenpar <- tune.lucid(G = G1, Z = Z1, Y = Y1, family = "binary",
Rho_G = seq(0.01, 0.02, by = 0.005),
Rho_Z_InvCov = seq(0.1, 0.3, by = 0.1),
Rho_Z_CovMu = seq(80, 100, by = 10))
}
}
