% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_lucid.R
\name{def.tune}
\alias{def.tune}
\title{Define tuning parameters of regularization for LUCID model.}
\usage{
def.tune(
  Rho_G = 0,
  Rho_Z_InvCov = 0,
  Rho_Z_CovMu = 0,
  Select_G = FALSE,
  Select_Z = FALSE
)
}
\arguments{
\item{Rho_G}{Numeric. Penalty for selection on genetic features/environmental exposures.}

\item{Rho_Z_InvCov}{Numeric. Penalty for the inverse of the covariance of biomarkers, which will produce a sparse matrix.}

\item{Rho_Z_CovMu}{Numeric. Penalty for the product of the inverse of the covariance of biomarkers, which will produce a sparse matrix for the mean.}

\item{Select_G}{Flag for variable selection in genetic features/environmental exposures. Default is FALSE.}

\item{Select_Z}{Flag for variable selection in biomarkers. Default is FALSE.}
}
\value{
A list of tuning parameters and settings will be returned for integrative clustering.
}
\description{
Define tuning parameters of regularization for LUCID model.
}
\author{
Yinqi Zhao, Cheng Peng, Zhao Yang, David V. Conti
}
