#' @importFrom parallel mclapply
#' @importFrom stats as.dist as.formula cutree dlnorm formula hclust lowess median model.matrix na.omit optim pgamma plnorm pnorm predict qnorm runif sd supsmu var wilcox.test
#'
predict.ltrcrfsrc <-
  function(object,
           newdata,
           m.target = NULL,
           importance = c(FALSE, TRUE, "none", "permute", "random", "anti"),
           get.tree = NULL,
           block.size = if (any(is.element(as.character(importance), c("none", "FALSE")))) NULL else 10,
           ensemble = NULL,
           na.action = c("na.omit", "na.impute"),
           outcome = c("train", "test"),
           proximity = FALSE,
           forest.wt = FALSE,
           ptn.count = 0,
           distance = FALSE,
           var.used = c(FALSE, "all.trees", "by.tree"),
           split.depth = c(FALSE, "all.trees", "by.tree"),
           seed = NULL,
           do.trace = FALSE,
           membership = FALSE,
           statistics = FALSE,

           ...)
{
  result.predict <- generic.predict.ltrcrfsrc(object,
                                              newdata,
                                              ensemble = ensemble,
                                              m.target = m.target,
                                              importance = importance,
                                              get.tree = get.tree,
                                              block.size = block.size,
                                              na.action = na.action,
                                              outcome = outcome,
                                              proximity = proximity,
                                              forest.wt = forest.wt,
                                              ptn.count = ptn.count,
                                              distance = distance,
                                              var.used = var.used,
                                              split.depth = split.depth,
                                              seed = seed,
                                              do.trace = do.trace,
                                              membership = membership,
                                              statistics = statistics,
                                              ...)
  return(result.predict)
}
