% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pbcsample}
\alias{pbcsample}
\title{Sample Mayo Clinic Primary Biliary Cirrhosis Data}
\source{
P. A. Murtaugh, E. R. Dickson, G. M. V. Dam,
M. Malinchoc, P. M. Grambsch, A. L. Langworthy, and C. H. Gips. (1989).
Primary biliary cirrhosis: Prediction of shortterm survival based on
repeated patient visits. \emph{Hepatology}, \strong{20}, 126-134.
}
\value{
a data frame with 57 rows and 9 variables:
  \item{ID}{Patient id}
  \item{Start}{the left truncation time point for the corresponding
  pseudo-subject observation}
  \item{Stop}{the right censoring time point for the corresponding
  pseudo-subject observation}
  \item{Event}{a binary value, with \code{1} indicating the event occurring at
  the corresponding \code{Stop}, \code{0} indicating right-censored}
  \item{age}{patient's age at entry, in years}
  \item{alk.phos}{alkaline phosphotase (U/liter)}
  \item{ast}{aspartate aminotransferase (U/ml)}
  \item{chol}{serum cholesterol (mg/dl)}
  \item{edema}{\code{0}--no edema, \code{0.5}--untreated or successfully treated,
  \code{1}--edema despite diuretic therapy}
}
\description{
A sample real dataset with time varying covariates. It contains multiple records
of measurements of risk factors at multiple time points from 10 patients
with primary biliary cirrhosis (PBC), constructed from
\code{\link{pbcseq}} in the R package \pkg{\link{survival}}. The data
structure has been reformatted with left-truncated right-censored
pseudo-subject observations based on the Andersen-Gill reformulation method.
}
\references{
Andersen, P. and Gill, R. (1982). Cox's regression model for counting
processes, a large sample study. \emph{Annals of Statistics}, \strong{10}, 1100-1120.
}
