% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Covariance_Matrix_Functions.R
\name{construct_covmat}
\alias{construct_covmat}
\title{Constructing a covariance matrix for a variable number of
phenotypes}
\usage{
construct_covmat(
  fam_vec = c("m", "f", "s1", "mgm", "mgf", "pgm", "pgf"),
  n_fam = NULL,
  add_ind = TRUE,
  h2 = 0.5,
  genetic_corrmat = NULL,
  full_corrmat = NULL,
  phen_names = NULL
)
}
\arguments{
\item{fam_vec}{A vector of strings holding the different
family members. All family members must be represented by strings from the
following list:
- \code{m} (Mother)
- \code{f} (Father)
- \code{c[0-9]*.[0-9]*} (Children)
- \code{mgm} (Maternal grandmother)
- \code{mgf} (Maternal grandfather)
- \code{pgm} (Paternal grandmother)
- \code{pgf} (Paternal grandfather)
- \code{s[0-9]*} (Full siblings)
- \code{mhs[0-9]*} (Half-siblings - maternal side)
- \code{phs[0-9]*} (Half-siblings - paternal side)
- \code{mau[0-9]*} (Aunts/Uncles - maternal side)
- \code{pau[0-9]*} (Aunts/Uncles - paternal side).
 Defaults to c("m","f","s1","mgm","mgf","pgm","pgf").}

\item{n_fam}{A named vector holding the desired number of family members.
See \code{\link[stats]{setNames}}.
All names must be picked from the list mentioned above. Defaults to NULL.}

\item{add_ind}{A logical scalar indicating whether the genetic
component of the full liability as well as the full
liability for the underlying individual should be included in
the covariance matrix. Defaults to TRUE.}

\item{h2}{Either a number representing the heritability
on liability scale for one single phenotype or a numeric vector representing
the liability-scale heritabilities for a positive number of phenotypes.
All entries in h2 must be non-negative and at most 1.}

\item{genetic_corrmat}{Either \code{NULL} or a numeric matrix holding the genetic correlations between the desired
phenotypes. All diagonal entries must be equal to one, while all off-diagonal entries
must be between -1 and 1. In addition, the matrix must be symmetric.
Defaults to NULL.}

\item{full_corrmat}{Either \code{NULL} or a  numeric matrix holding the full correlations between the desired
phenotypes. All diagonal entries must be equal to one, while all off-diagonal entries
must be between -1 and 1. In addition, the matrix must be symmetric.
Defaults to NULL.}

\item{phen_names}{Either \code{NULL} or a character vector holding the phenotype names. These names
will be used to create the row and column names for the covariance matrix.
If it is not specified, the names will default to phenotype1, phenotype2, etc.
Defaults to NULL.}
}
\value{
If either \code{fam_vec} or \code{n_fam} is used as the argument, if it is of
the required format, if \code{add_ind} is a logical scalar and \code{h2} is a
number satisfying \deqn{0 \leq h2 \leq 1}, then the function \code{construct_covmat}
will return a named covariance matrix, which row- and column-number
corresponds to the length of \code{fam_vec} or \code{n_fam} (+ 2 if \code{add_ind=TRUE}).
However, if \code{h2} is a numeric vector satisfying
\deqn{0 \leq h2_i \leq 1} for all \deqn{i \in \{1,...,n_pheno\}} and if
\code{genetic_corrmat} and \code{full_corrmat} are two numeric and symmetric matrices
satisfying that all diagonal entries are one and that all off-diagonal
entries are between -1 and 1, then \code{construct_covmat} will return
a named covariance matrix, which number of rows and columns corresponds to the number
of phenotypes times the length of \code{fam_vec} or \code{n_fam} (+ 2 if \code{add_ind=TRUE}).
If both \code{fam_vec} and \code{n_fam} are equal to \code{c()} or \code{NULL},
the function returns either a \eqn{2 \times 2} matrix holding only the correlation
between the genetic component of the full liability and the full liability for the
individual under consideration, or a \deqn{(2 \times n_pheno) \times (2\times n_pheno)}
matrix holding the correlation between the genetic component of the full
liability and the full liability for the underlying individual for all
phenotypes.
If both \code{fam_vec} and \code{n_fam} are specified, the user is asked to
decide on which of the two vectors to use.
Note that the returned object has different attributes, such as
\code{fam_vec}, \code{n_fam}, \code{add_ind} and \code{h2}.
}
\description{
\code{construct_covmat} returns the covariance matrix for an
underlying target individual and a variable number of its family members
for a variable number of phenotypes. It is a wrapper around
\code{\link{construct_covmat_single}} and \code{\link{construct_covmat_multi}}.
}
\details{
This function can be used to construct a covariance matrix for
a given number of family members. If \code{h2} is a number,
each entry in this covariance matrix equals the percentage
of shared DNA between the corresponding individuals times
the liability-scale heritability \deqn{h^2}. However, if \code{h2} is a numeric vector,
and genetic_corrmat and full_corrmat are two symmetric correlation matrices,
each entry equals either the percentage of shared DNA between the corresponding
individuals times the liability-scale heritability \deqn{h^2} or the
percentage of shared DNA between the corresponding individuals times
the correlation between the corresponding phenotypes. The family members
can be specified using one of two possible formats.
}
\examples{
construct_covmat()
construct_covmat(fam_vec = c("m","mgm","mgf","mhs1","mhs2","mau1"),
                 n_fam = NULL,
                 add_ind = TRUE,
                 h2 = 0.5)
construct_covmat(fam_vec = NULL,
                 n_fam = stats::setNames(c(1,1,1,2,2), c("m","mgm","mgf","s","mhs")),
                 add_ind = FALSE,
                 h2 = 0.3)
construct_covmat(h2 = c(0.5,0.5), genetic_corrmat = matrix(c(1,0.4,0.4,1), nrow = 2),
                 full_corrmat = matrix(c(1,0.6,0.6,1), nrow = 2))

}
\seealso{
\code{\link{get_relatedness}}, \code{\link{construct_covmat_single}},
\code{\link{construct_covmat_multi}}
}
