% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariableImportancePlot.R
\name{VariableImportancePlot}
\alias{VariableImportancePlot}
\title{Barplot comparing the feature importance across different learning methods.}
\usage{
VariableImportancePlot(DT = NULL, RF = NULL, GBM = NULL)
}
\arguments{
\item{DT}{A fitted decision tree model object}

\item{RF}{A fitted random forest model object}

\item{GBM}{A fitted gradient boosting model object}
}
\value{
This function returns a barplot that compares the standardized feature importance across different tree-based machine learning methods. These measures are computed via the caret package.
}
\description{
Barplot comparing the feature importance across different learning methods.
}
\examples{
\donttest{
library(gbm)
colnames(training)[14] <- "perf"
ensemblist <- TreeModels(traindata = training,
methodlist = c("dt", "rf","gbm"),checkprogress = TRUE)

VariableImportancePlot(DT = ensemblist$ModelObject$rpart,
RF = ensemblist$ModelObject$ranger,GBM = ensemblist$ModelObject$gbm)

VariableImportancePlot(RF = ensemblist$ModelObject$ranger,
GBM = ensemblist$ModelObject$gbm)

VariableImportancePlot(DT = ensemblist$ModelObject$rpart)
}
}
