% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.R
\name{vcov}
\alias{vcov}
\alias{vcov.lmm}
\title{Extract The Variance-Covariance Matrix From a Linear Mixed Model}
\usage{
\method{vcov}{lmm}(
  object,
  effects = "mean",
  robust = FALSE,
  df = FALSE,
  type.object = "lmm",
  strata = NULL,
  data = NULL,
  p = NULL,
  type.information = NULL,
  transform.sigma = NULL,
  transform.k = NULL,
  transform.rho = NULL,
  transform.names = TRUE,
  ...
)
}
\arguments{
\item{object}{a \code{lmm} object.}

\item{effects}{[character] Should the variance-covariance matrix for all coefficients be output (\code{"all"}),
or only for coefficients relative to the mean (\code{"mean"} or \code{"fixed"}),
or only for coefficients relative to the variance structure (\code{"variance"}),
or only for coefficients relative to the correlation structure (\code{"correlation"}).}

\item{robust}{[logical] Should robust standard error (aka sandwich estimator) be output instead of the model-based standard errors. Not feasible for variance or correlation coefficients estimated by REML.}

\item{df}{[logical] Should degree of freedom, computed using Satterthwaite approximation, for the model parameters be output.}

\item{type.object}{[character] Set this argument to \code{"gls"} to obtain the output from the gls object and related methods.}

\item{strata}{[character vector] When not \code{NULL}, only output the variance-covariance matrix for the estimated parameters relative to specific levels of the variable used to stratify the mean and covariance structure.}

\item{data}{[data.frame] dataset relative to which the information should be computed. Only relevant if differs from the dataset used to fit the model.}

\item{p}{[numeric vector] value of the model coefficients at which to evaluate the information. Only relevant if differs from the fitted values.}

\item{type.information}{[character] Should the expected information be used  (i.e. minus the expected second derivative) or the observed inforamtion (i.e. minus the second derivative).}

\item{transform.sigma}{[character] Transformation used on the variance coefficient for the reference level. One of \code{"none"}, \code{"log"}, \code{"square"}, \code{"logsquare"} - see details.}

\item{transform.k}{[character] Transformation used on the variance coefficients relative to the other levels. One of \code{"none"}, \code{"log"}, \code{"square"}, \code{"logsquare"}, \code{"sd"}, \code{"logsd"}, \code{"var"}, \code{"logvar"} - see details.}

\item{transform.rho}{[character] Transformation used on the correlation coefficients. One of \code{"none"}, \code{"atanh"}, \code{"cov"} - see details.}

\item{transform.names}{[logical] Should the name of the coefficients be updated to reflect the transformation that has been used?}

\item{...}{Not used. For compatibility with the generic method.}
}
\value{
A matrix with an attribute \code{"df"} when argument df is set to \code{TRUE}.
}
\description{
Extract the variance-covariance matrix of the model coefficients of a multivariate gaussian model.
}
\details{
For details about the arguments \bold{transform.sigma}, \bold{transform.k}, \bold{transform.rho}, see the documentation of the \link[LMMstar]{coef} function.
}
