% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AQSys.mrgsn.R
\name{AQSysOthmer}
\alias{AQSysOthmer}
\title{Othmer's Equation - Tieline's correlation}
\usage{
AQSysOthmer(TLdt, ...)
}
\arguments{
\item{TLdt}{- Tieline Experimental data that will be used in the nonlinear fit}

\item{...}{Additional optional arguments. None are used at present.}
}
\value{
Parameters K, n and Statistical data
}
\description{
Othmer's equation to correlate tieline's data applying the lever's rule.
}
\examples{
# TLdt is a data.frame which contains series of Tieline's mass fraction
# (upper-rich component, bottom-rich component and water)
# Each column in the data.frame represents a series of one component mass fraction
# For example, an empty data.frame for four tielines can be obtaining using:
TLdt<-matrix(NA,nrow=4,ncol=6)
# Variables order must follows the sequence presented below:
# "mfXt","mfYt","mfXb","mfYb","mfWt","mfWb"
# In which: mf stands for mass fraction; X and Y for the component
# rich in bottom and upper phase, respectively; t or b for top and
# bottom phases and W for water.
# Then you just need to load the data.frame in the function:
\dontrun{
AQSysOthmer(TLdt)
}
}
\references{
OTHMER, D.; TOBIAS, P. Liquid-Liquid Extraction Data - The Line Correlation. Industrial & Engineering Chemistry, v. 34, n. 6, p. 693-696, 1942/06/01 1942. ISSN 0019-7866. 
(\href{https://pubs.acs.org/doi/abs/10.1021/ie50390a600}{ACS Publications})
}
