% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSA.R
\name{OSA}
\alias{OSA}
\title{The OSA gives a simple average estimatoris by averaging all these least squares estimators.}
\usage{
OSA(X, Y, alpha, K, nk)
}
\arguments{
\item{X}{is a design matrix}

\item{Y}{is a random response vector of observed values}

\item{alpha}{is the significance level}

\item{K}{is the number of subsets}

\item{nk}{is the sample size of subsets}
}
\value{
MUA,BetaA,MAEMUA,MSEMUA
}
\description{
The OSA gives a simple average estimatoris by averaging all these least squares estimators.
}
\examples{
set.seed(12)
X=matrix(data=sample(1:3,1200*5, replace = TRUE) ,nrow=1200,ncol=5)  
b=sample(1:3,5, replace = TRUE)         
e= rnorm(1200, 0, 1)    
Y=X\%*\%b+e
alpha=0.05	
K=10
nk=1200/K 
OSA(X,Y,alpha,K,nk)
}
