% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVfunctionRange.R
\name{CV_Range}
\alias{CV_Range}
\title{Change variance of distribution while keeping the mean constant}
\usage{
CV_Range(
  sampleVector,
  lower_CV_Bound,
  upper_CV_Bound,
  maxRandIter = 10000,
  plot = F
)
}
\arguments{
\item{sampleVector}{The vector containing the initial values with initial
distribution and CV}

\item{lower_CV_Bound}{The lower CV value we wish the distribution to achieve.}

\item{upper_CV_Bound}{The upper CV value we wish the distribution to achieve.}

\item{maxRandIter}{The function uses a stochastic algorithm to change the
CV values from the lower to the upper value desired. If these bounds have not
been achieved after maxRandIter iterations (default=10000), the function will
exit, in order to avoid a possible infinite loop.}

\item{plot}{If set to TRUE, will plot the resulting variances (default=FALSE)}
}
\value{
A data frame where each column contains a distribution of values with
increasing CV, from the lower bound to upper bound.
}
\description{
Takes as input a vector of values that have a distribution with a variance
expressed as coefficient of variation (CV), It then modifies the
distribution, so that the CV changes from a lower bound (lower_CV_bound)
to an upper bound (upper_CV_bound), while the mean stays constant.
Optionally, it can also plot the
resulting variances.
}
\examples{
\dontrun{
DataFrame=CV_Range(sampleA$LDL,0,100,maxRandIter = 100, plot=TRUE)
}
}
