% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TS.R
\name{est_changepoints}
\alias{est_changepoints}
\title{Use ptMCMC to estimate the distribution of change point locations}
\usage{
est_changepoints(data, formula, nchangepoints, timename, weights,
  control = list())
}
\arguments{
\item{data}{\code{data.frame} including [1] the time variable (indicated 
in \code{timename}), [2] the predictor variables (required by
\code{formula}) and [3], the multinomial response variable (indicated in
\code{formula}) as verified by \code{\link{check_timename}} and 
\code{\link{check_formula}}. Note that the response variables should be
formatted as a \code{data.frame} object named as indicated by the 
\code{response} entry in the \code{control} list, such as \code{gamma} 
for a standard TS analysis on LDA output.}

\item{formula}{\code{\link[stats]{formula}} defining the regression between
relationship the change points. Any 
predictor variable included must also be a column in 
\code{data} and any (multinomial) response variable must be a set of
columns in \code{data}, as verified by \code{\link{check_formula}}.}

\item{nchangepoints}{\code{integer} corresponding to the number of 
change points to include in the model. 0 is a valid input (corresponding
to no change points, so a singular time series model), and the current 
implementation can reasonably include up to 6 change points. The 
number of change points is used to dictate the segmentation of the 
time series into chunks fit with separate models dictated by 
\code{formula}.}

\item{timename}{\code{character} element indicating the time variable
used in the time series.}

\item{weights}{Optional class \code{numeric} vector of weights for each 
document. Defaults to \code{NULL}, translating to an equal weight for
each document. When using \code{multinom_TS} in a standard LDATS 
analysis, it is advisable to weight the documents by their total size,
as the result of \code{\link[topicmodels]{LDA}} is a matrix of 
proportions, which does not account for size differences among documents.
For most models, a scaling of the weights (so that the average is 1) is
most appropriate, and this is accomplished using \code{document_weights}.}

\item{control}{A \code{list} of parameters to control the fitting of the
Time Series model including the parallel tempering Markov Chain 
Monte Carlo (ptMCMC) controls. Values not input assume defaults set by 
\code{\link{TS_control}}.}
}
\value{
List of saved data objects from the ptMCMC estimation of
  change point locations (unless \code{nchangepoints} is 0, then 
  \code{NULL} is returned).
}
\description{
This function executes ptMCMC-based estimation of the 
  change point location distributions for multinomial Time Series analyses.
}
\examples{
\donttest{
  data(rodents)
  document_term_table <- rodents$document_term_table
  document_covariate_table <- rodents$document_covariate_table
  LDA_models <- LDA_set(document_term_table, topics = 2)[[1]]
  data <- document_covariate_table
  data$gamma <- LDA_models@gamma
  weights <- document_weights(document_term_table)
  formula <- gamma ~ 1
  nchangepoints <- 1
  control <- TS_control()
  data <- data[order(data[,"newmoon"]), ]
  rho_dist <- est_changepoints(data, formula, nchangepoints, "newmoon", 
                               weights, control)
}

}
