% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multinom_TS.R
\name{verify_changepoint_locations}
\alias{verify_changepoint_locations}
\title{Verify the change points of a multinomial time series model}
\usage{
verify_changepoint_locations(data, changepoints = NULL,
  timename = "time")
}
\arguments{
\item{data}{Class \code{data.frame} object including the predictor and 
response variables.}

\item{changepoints}{Numeric vector indicating locations of the change 
points. Must be conformable to \code{integer} values.}

\item{timename}{\code{character} element indicating the time variable
used in the time series. Defaults to \code{"time"}. The variable must be
integer-conformable or a \code{Date}. If the variable named
is a \code{Date}, the input is converted to an integer, resulting in the
timestep being 1 day, which is often not desired behavior.}
}
\value{
Logical indicator of the check passing \code{TRUE} or failing
  \code{FALSE}.
}
\description{
Verify that a time series can be broken into a set 
  of chunks based on input change points.
}
\examples{
  data(rodents)
  dtt <- rodents$document_term_table
  lda <- LDA_set(dtt, 2, 1, list(quiet = TRUE))
  dct <- rodents$document_covariate_table
  dct$gamma <- lda[[1]]@gamma
  verify_changepoint_locations(dct, changepoints = 100, 
                               timename = "newmoon")   

}
