% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multinom_TS.R
\name{package_chunk_fits}
\alias{package_chunk_fits}
\title{Package the output of the chunk-level multinomial models into a
  multinom_TS_fit list}
\usage{
package_chunk_fits(chunks, fits)
}
\arguments{
\item{chunks}{Data frame of \code{start} and \code{end} times for each 
chunk (row).}

\item{fits}{List of chunk-level fits returned by \code{TS_chunk_memo},
the memoised version of \code{\link{multinom_TS_chunk}}.}
}
\value{
Object of class \code{multinom_TS_fit}, which is a list of [1]
  chunk-level model fits, [2] the total log likelihood combined across 
  all chunks, and [3] the chunk time data table.
}
\description{
Takes the list of fitted chunk-level models returned from
  \code{TS_chunk_memo} (the memoised version of 
  \code{\link{multinom_TS_chunk}} and packages it as a 
  \code{multinom_TS_fit} object. This involves naming the model fits based 
  on the chunk time windows, combining the log likelihood values across the 
  chunks, and setting the class of the output object.
}
\examples{
  data(rodents)
  dtt <- rodents$document_term_table
  lda <- LDA_set(dtt, 2, 1, list(quiet = TRUE))
  dct <- rodents$document_covariate_table
  dct$gamma <- lda[[1]]@gamma
  weights <- document_weights(dtt)
  formula <- gamma ~ 1
  changepoints <- c(20,50)
  timename <- "newmoon"
  TS_chunk_memo <- memoise_fun(multinom_TS_chunk, TRUE)
  chunks <- prep_chunks(dct, changepoints, timename)
  nchunks <- nrow(chunks)
  fits <- vector("list", length = nchunks)
  for (i in 1:nchunks){
    fits[[i]] <- TS_chunk_memo(dct, formula, chunks[i, ], timename, 
                               weights, TS_control())
  }
  package_chunk_fits(chunks, fits) 

}
