% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{sim_LDA_TS_data}
\alias{sim_LDA_TS_data}
\title{Simulate LDA_TS data from LDA and TS model structures and parameters}
\usage{
sim_LDA_TS_data(N, Beta, X, Eta, rho, tD, err = 0, seed = NULL)
}
\arguments{
\item{N}{A vector of document sizes (total word counts). Must be integer
conformable. Is used to infer the total number of documents.}

\item{Beta}{\code{matrix} of categorical distribution parameters defining
terms within topics. Dimension: k x V (number of topics x number of 
terms). Used to infer both (k) and (V). Must be non-negative and sum to 
1 within topics.}

\item{X}{\code{matrix} of covariates, dimension M (number of documents) x 
SC (number of segments x number of covariates, including the intercept).}

\item{Eta}{\code{matrix} of regression parameters across the segments,
dimension: SC (number of segments x number of covariates, including the
intercept) x k (number of topics).}

\item{rho}{Vector of integer-conformable time locations of changepoints or 
\code{NULL} if no changepoints. Used to determine the number of 
segments. Must exist within the bounds of the times of the documents,
\code{tD}.}

\item{tD}{Vector of integer-conformable times of the documents. Must be
of length M (as determined by \code{X}).}

\item{err}{Additive error on the link-scale. Must be a non-negative 
\code{numeric} value. Default value of \code{0} indicates no error.}

\item{seed}{Input to \code{\link{set.seed}}.}
}
\value{
A document-by-term \code{matrix} of counts (dim: M x V).
}
\description{
For a given set of covariates \code{X}; parameters 
  \code{Beta}, \code{Eta}, \code{rho}, and \code{err}; and 
  document-specific time stamps \code{tD} and lengths \code{N}),
  simulate a document-by-topic matrix.
  Additional structuring variables (the numbers of topics (k), terms (V), 
  documents (M), segments (S), and covariates per segment (C))
  are inferred from input objects.
}
\examples{
  N <- c(10, 22, 15, 31)
  tD <- c(1, 3, 4, 6)
  rho <- 3
  X <- matrix(c(1,1,0,0,1,2,0,0,0,0,1,3,0,0,1,4), 
           nrow = length(tD), ncol = 4, byrow = TRUE)
  Eta <- matrix(c(0.5, 1.2, 0.3, 1.1, 0.9, 0.1, 0.5, 0.5), 
           nrow = ncol(X), ncol = 2, byrow = TRUE)
  Beta <- matrix(c(0.1, 0.1, 0.8, 0.2, 0.6, 0.2), 2, 3, byrow = TRUE)
  err <- 1
  sim_LDA_TS_data(N, Beta, X, Eta, rho, tD, err)
  
}
