## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
devtools::load_all()
library(LA)

## -----------------------------------------------------------------------------
toy=rOofA(k=4);toy

## -----------------------------------------------------------------------------
toy=rOofA(n=12,k=4);toy

## -----------------------------------------------------------------------------
try.OofA=LA_OofA(n=12,k=4);try.OofA

## -----------------------------------------------------------------------------
try.LHD1=LA_LHD(n=6,k=3);try.LHD1

## -----------------------------------------------------------------------------
try.LHD2=LA_LHD(n=9,k=4,OC="AvgAbsCor");try.LHD2

## -----------------------------------------------------------------------------
try.LHD2=LA_LHD(n=12,k=5,OC="MaxProCriterion");try.LHD2

## -----------------------------------------------------------------------------
SDP=function(x){i=1:length(x);y=sum(abs(x)^(i=1));return(y)}

## -----------------------------------------------------------------------------
try=LA_opt(of=SDP,lb=rep(-1,20),ub=rep(1,20),N=10,type="mini")
SDP(try)  #Note that the true global optimum is 0, but we only have 10 iterations here

## -----------------------------------------------------------------------------
CiT=function(x){x1=x[1];x2=x[2];y=-0.0001*(abs(sin(x1)*sin(x2)*exp(abs(100-sqrt(x1^2+x2^2)/pi)))+1)^0.1;return(y)}

## -----------------------------------------------------------------------------
try2=LA_opt(of=CiT,lb=rep(-10,2),ub=rep(10,2),N=10,type="mini")
CiT(try2) #Note that the true global optimum is -2.06261, but we only have 10 iterations

## -----------------------------------------------------------------------------
matrix(c(rep(1,20),rep(0,10),rep(24,10)),ncol=2,nrow=20,byrow=FALSE)

## -----------------------------------------------------------------------------
D=function(x){IM=t(x)%*%x;return(det(IM))}

## -----------------------------------------------------------------------------
try3=LA_opt(n=20,lb=c(1,0),ub=c(1,24),N=10,OC=D,type="maxi")
try3 #with more iterations, LA would return even better result.

